/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data.entity;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;

public interface ILootrCart
extends ILootrInfoProvider {
    @Override
    @Deprecated
    default public ILootrInfo.LootrInfoType getInfoType() {
        return ILootrInfo.LootrInfoType.CONTAINER_ENTITY;
    }

    default public Entity asEntity() {
        ILootrCart iLootrCart = this;
        if (iLootrCart instanceof Entity) {
            Entity entity = (Entity)iLootrCart;
            return entity;
        }
        throw new NullPointerException("ILootrCart implementation is not an Entity and doesn't provide asEntity()!");
    }

    @Override
    default public void performOpen(ServerPlayer player) {
        PlatformAPI.performCartOpen(this, player);
    }

    @Override
    default public void performOpen() {
        PlatformAPI.performCartOpen(this);
    }

    @Override
    default public void performClose(ServerPlayer player) {
        PlatformAPI.performCartClose(this, player);
    }

    @Override
    default public void performClose() {
        PlatformAPI.performCartClose(this);
    }

    @Override
    default public void performDecay() {
        Entity newCart;
        EntityType<?> type;
        Level level = this.getInfoLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        boolean replaceWhenDecayed = LootrAPI.shouldReplaceWhenDecayed();
        Entity entity = this.asEntity();
        if (replaceWhenDecayed && (type = this.getInfoNewType().getReplacementEntity()) != null && (newCart = type.create(level)) != null) {
            newCart.setPos(entity.position());
            newCart.setXRot(entity.getXRot());
            newCart.setYRot(entity.getYRot());
            level.addFreshEntity(newCart);
        }
        entity.discard();
    }
}

