/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import noobanidus.mods.lootr.common.block.entity.LootrBrushableBlockEntity;
import noobanidus.mods.lootr.common.client.ClientHooks;

public class LootrBrushableBlockRenderer
implements BlockEntityRenderer<LootrBrushableBlockEntity> {
    private final ItemRenderer itemRenderer;

    public LootrBrushableBlockRenderer(BlockEntityRendererProvider.Context arg) {
        this.itemRenderer = arg.getItemRenderer();
    }

    public void render(LootrBrushableBlockEntity arg, float f, PoseStack arg2, MultiBufferSource arg3, int k, int l) {
        if (arg.getLevel() != null) {
            ItemStack itemstack;
            Direction direction;
            Player player = ClientHooks.getPlayer();
            if (player == null) {
                return;
            }
            if (arg.hasOpened(player)) {
                return;
            }
            if (!arg.isBrushingPlayer(player)) {
                return;
            }
            int i = (Integer)arg.getBlockState().getValue((Property)BlockStateProperties.DUSTED);
            if (i > 0 && (direction = arg.getHitDirection()) != null && !(itemstack = arg.getItem()).isEmpty()) {
                arg2.pushPose();
                arg2.translate(0.0f, 0.5f, 0.0f);
                float[] afloat = this.translations(direction, i);
                arg2.translate(afloat[0], afloat[1], afloat[2]);
                arg2.mulPose(Axis.YP.rotationDegrees(75.0f));
                boolean flag = direction == Direction.EAST || direction == Direction.WEST;
                arg2.mulPose(Axis.YP.rotationDegrees((float)((flag ? 90 : 0) + 11)));
                arg2.scale(0.5f, 0.5f, 0.5f);
                int j = LevelRenderer.getLightColor((BlockAndTintGetter)arg.getLevel(), (BlockState)arg.getBlockState(), (BlockPos)arg.getBlockPos().relative(direction));
                this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, j, OverlayTexture.NO_OVERLAY, arg2, arg3, arg.getLevel(), 0);
                arg2.popPose();
            }
        }
    }

    private float[] translations(Direction arg, int i) {
        float[] afloat = new float[]{0.5f, 0.0f, 0.5f};
        float f = (float)i / 10.0f * 0.75f;
        switch (arg) {
            case EAST: {
                afloat[0] = 0.73f + f;
                break;
            }
            case WEST: {
                afloat[0] = 0.25f - f;
                break;
            }
            case UP: {
                afloat[1] = 0.25f + f;
                break;
            }
            case DOWN: {
                afloat[1] = -0.23f - f;
                break;
            }
            case NORTH: {
                afloat[2] = 0.25f - f;
                break;
            }
            case SOUTH: {
                afloat[2] = 0.73f + f;
            }
        }
        return afloat;
    }

    public AABB getRenderBoundingBox(LootrBrushableBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 0.25, (double)pos.getY() - 0.25, (double)pos.getZ() - 0.25, (double)pos.getX() + 1.25, (double)pos.getY() + 1.25, (double)pos.getZ() + 1.25);
    }
}

