/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.BuiltInLootrTypes;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.SimpleLootrEntity;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootrShulkerBlockEntity
extends RandomizableContainerBlockEntity
implements ILootrBlockEntity {
    protected final SimpleLootrEntity simpleLootrEntity = new SimpleLootrEntity(this::getVisualOpeners, 27);
    private int openCount;
    private ShulkerBoxBlockEntity.AnimationStatus animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;

    public LootrShulkerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(LootrRegistry.getShulkerBlockEntity(), pWorldPosition, pBlockState);
    }

    @Override
    public void defaultTick(Level level, BlockPos pos, BlockState state) {
        ILootrBlockEntity.super.defaultTick(level, pos, state);
        this.updateAnimation(level, pos, state);
    }

    private void updateAnimation(Level pLevel, BlockPos pPos, BlockState pState) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (this.progressOld == 0.0f) {
                    LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                if (this.progress >= 1.0f) {
                    this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                this.moveCollidedEntities(pLevel, pPos, pState);
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (this.progressOld == 1.0f) {
                    LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
                this.progress = 0.0f;
                LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
            }
        }
    }

    public ShulkerBoxBlockEntity.AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AABB getBoundingBox(BlockState pState) {
        return Shulker.getProgressAabb((float)1.0f, (Direction)((Direction)pState.getValue((Property)ShulkerBoxBlock.FACING)), (float)(0.5f * this.getProgress(1.0f)));
    }

    private void moveCollidedEntities(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pState.getBlock() instanceof ShulkerBoxBlock) {
            Direction direction = (Direction)pState.getValue((Property)ShulkerBoxBlock.FACING);
            AABB aabb = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)direction, (float)this.progressOld, (float)this.progress).move(pPos);
            List list = pLevel.getEntities(null, aabb);
            for (Entity entity : list) {
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                entity.move(MoverType.SHULKER_BOX, new Vec3((aabb.getXsize() + 0.01) * (double)direction.getStepX(), (aabb.getYsize() + 0.01) * (double)direction.getStepY(), (aabb.getZsize() + 0.01) * (double)direction.getStepZ()));
            }
        }
    }

    public int getContainerSize() {
        return this.simpleLootrEntity.getInfoContainerSize();
    }

    public boolean triggerEvent(int pEvent, int pCount) {
        if (pEvent == 1) {
            this.openCount = pCount;
            if (pCount == 0) {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSING;
            }
            if (pCount == 1) {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.OPENING;
            }
            return true;
        }
        return super.triggerEvent(pEvent, pCount);
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            if (!this.simpleLootrEntity.hasBeenOpened()) {
                this.simpleLootrEntity.setHasBeenOpened();
                this.markChanged();
            }
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount == 1) {
                this.level.gameEvent((Entity)pPlayer, (Holder)GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.level.playSound(null, this.worldPosition, SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            --this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.level.gameEvent((Entity)pPlayer, (Holder)GameEvent.CONTAINER_CLOSE, this.worldPosition);
                this.level.playSound(null, this.worldPosition, SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.shulkerBox");
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return null;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tryLoadLootTable(compound);
        this.simpleLootrEntity.loadAdditional(compound, provider);
    }

    public void saveToItem(ItemStack itemstack, HolderLookup.Provider provider) {
        this.simpleLootrEntity.setSavingToItem(true);
        super.saveToItem(itemstack, provider);
        this.simpleLootrEntity.setSavingToItem(false);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.trySaveLootTable(compound);
        this.simpleLootrEntity.saveAdditional(compound, provider, this.level != null && this.level.isClientSide());
    }

    protected NonNullList<ItemStack> getItems() {
        return this.simpleLootrEntity.getItems();
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
    }

    public float getProgress(float pPartialTicks) {
        return Mth.lerp((float)pPartialTicks, (float)this.progressOld, (float)this.progress);
    }

    public boolean isClosed() {
        return this.animationStatus == ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
    }

    @Override
    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.simpleLootrEntity.getClientOpeners();
    }

    @Override
    @Deprecated
    public LootrBlockType getInfoBlockType() {
        return LootrBlockType.SHULKER;
    }

    @Override
    public ILootrType getInfoNewType() {
        return BuiltInLootrTypes.SHULKER;
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        return this.simpleLootrEntity.getInfoUUID();
    }

    @Override
    public String getInfoKey() {
        return this.simpleLootrEntity.getInfoKey();
    }

    @Override
    public boolean hasBeenOpened() {
        return this.simpleLootrEntity.hasBeenOpened();
    }

    @Override
    public boolean isPhysicallyOpen() {
        return !this.isClosed();
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag result = super.getUpdateTag(provider);
        this.simpleLootrEntity.fillUpdateTag(result, provider, this.level != null && this.level.isClientSide());
        return result;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    public void unpackLootTable(@Nullable Player player) {
    }

    @Override
    public void markChanged() {
        this.setChanged();
        this.markDataChanged();
    }

    @Override
    public boolean isClientOpened() {
        return this.simpleLootrEntity.isClientOpened();
    }

    @Override
    public void setClientOpened(boolean opened) {
        this.simpleLootrEntity.setClientOpened(opened);
    }

    @Override
    @NotNull
    public BlockPos getInfoPos() {
        return this.getBlockPos();
    }

    @Override
    public ResourceKey<LootTable> getInfoLootTable() {
        return this.getLootTable();
    }

    @Override
    @Nullable
    public Component getInfoDisplayName() {
        return this.getDisplayName();
    }

    @Override
    @NotNull
    public ResourceKey<Level> getInfoDimension() {
        return this.getLevel().dimension();
    }

    @Override
    public int getInfoContainerSize() {
        return this.getContainerSize();
    }

    @Override
    public long getInfoLootSeed() {
        return this.getLootTableSeed();
    }

    @Override
    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory() {
        return null;
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return false;
    }

    @Override
    public Level getInfoLevel() {
        return this.getLevel();
    }

    @Override
    public int getPhysicalOpenerCount() {
        return this.openCount;
    }

    @Override
    @Nullable
    public IContainerTrigger getTrigger() {
        return LootrRegistry.getShulkerTrigger();
    }

    private static void doNeighborUpdates(Level pLevel, BlockPos pPos, BlockState pState) {
        pState.updateNeighbourShapes((LevelAccessor)pLevel, pPos, 3);
        pLevel.updateNeighborsAt(pPos, pState.getBlock());
    }

    public static class DefaultBlockEntityConverter
    implements ILootrBlockEntityConverter<LootrShulkerBlockEntity> {
        @Override
        public ILootrBlockEntity apply(LootrShulkerBlockEntity blockEntity) {
            return blockEntity;
        }

        @Override
        public BlockEntityType<?> getBlockEntityType() {
            return LootrRegistry.getShulkerBlockEntity();
        }
    }
}

