/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import org.jetbrains.annotations.NotNull;

public class SimpleLootrEntity {
    private final NonNullList<ItemStack> items;
    private final Set<UUID> clientOpeners = new ObjectOpenHashSet();
    protected UUID infoId = null;
    protected boolean hasBeenOpened = false;
    private String cachedId;
    protected boolean clientOpened = false;
    private boolean savingToItem = false;
    private final Supplier<Set<UUID>> visualOpenersSupplier;

    public SimpleLootrEntity(Supplier<Set<UUID>> visualOpenersSupplier, int size) {
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        this.visualOpenersSupplier = visualOpenersSupplier;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public Set<UUID> getClientOpeners() {
        return this.clientOpeners;
    }

    public boolean isClientOpened() {
        return this.clientOpened;
    }

    public void setClientOpened(boolean opened) {
        this.clientOpened = opened;
    }

    @NotNull
    public UUID getInfoUUID() {
        if (this.infoId == null) {
            this.infoId = UUID.randomUUID();
        }
        return this.infoId;
    }

    public String getInfoKey() {
        if (this.cachedId == null) {
            this.cachedId = ILootrInfo.generateInfoKey(this.getInfoUUID());
        }
        return this.cachedId;
    }

    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    public int getInfoContainerSize() {
        return this.items.size();
    }

    public void setHasBeenOpened() {
        this.hasBeenOpened = true;
    }

    public boolean isSavingToItem() {
        return this.savingToItem;
    }

    public void setSavingToItem(boolean saving) {
        this.savingToItem = saving;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provder) {
        if (compound.hasUUID("LootrId")) {
            this.infoId = compound.getUUID("LootrId");
        }
        if (compound.contains("LootrHasBeenOpened", 1)) {
            this.hasBeenOpened = compound.getBoolean("LootrHasBeenOpened");
        }
        if (this.infoId == null) {
            this.getInfoUUID();
        }
        this.clientOpeners.clear();
        if (compound.contains("LootrOpeners")) {
            ListTag list = compound.getList("LootrOpeners", 11);
            for (Tag thisTag : list) {
                this.clientOpeners.add(NbtUtils.loadUUID((Tag)thisTag));
            }
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider, boolean isClientSide) {
        if (!LootrAPI.shouldDiscard() && !this.savingToItem) {
            compound.putUUID("LootrId", this.getInfoUUID());
        }
        compound.putBoolean("LootrHasBeenOpened", this.hasBeenOpened);
        if (isClientSide && !this.clientOpeners.isEmpty()) {
            ListTag list = new ListTag();
            for (UUID opener : this.clientOpeners) {
                list.add((Object)NbtUtils.createUUID((UUID)opener));
            }
            compound.put("LootrOpeners", (Tag)list);
        }
    }

    public void fillUpdateTag(CompoundTag result, HolderLookup.Provider provider, boolean isClientSide) {
        this.saveAdditional(result, provider, isClientSide);
        Set<UUID> currentOpeners = this.visualOpenersSupplier.get();
        if (currentOpeners != null) {
            ListTag list = new ListTag();
            for (UUID opener : Sets.intersection(currentOpeners, LootrAPI.getPlayerIds())) {
                list.add((Object)NbtUtils.createUUID((UUID)opener));
            }
            if (!list.isEmpty()) {
                result.put("LootrOpeners", (Tag)list);
            }
        }
    }
}

