/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LootrBarrelBlockEntity
extends RandomizableContainerBlockEntity
implements ILootrBlockEntity {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private final Set<UUID> clientOpeners = new ObjectLinkedOpenHashSet();
    protected UUID infoId = null;
    protected boolean hasBeenOpened = false;
    private String cachedId;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            if (!LootrBarrelBlockEntity.this.hasBeenOpened) {
                LootrBarrelBlockEntity.this.hasBeenOpened = true;
                LootrBarrelBlockEntity.this.markChanged();
            }
            LootrBarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_OPEN);
            LootrBarrelBlockEntity.this.updateBlockState(state, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            LootrBarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_CLOSE);
            LootrBarrelBlockEntity.this.updateBlockState(state, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int p_155069_, int p_155070_) {
        }

        protected boolean isOwnContainer(Player player) {
            ChestMenu chestMenu;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ChestMenu && (abstractContainerMenu = (chestMenu = (ChestMenu)abstractContainerMenu).getContainer()) instanceof ILootrInventory) {
                ILootrInventory data = (ILootrInventory)abstractContainerMenu;
                return data.getInfo().getInfoUUID().equals(LootrBarrelBlockEntity.this.getInfoUUID());
            }
            return false;
        }
    };
    protected boolean clientOpened = false;
    private boolean savingToItem = false;

    public LootrBarrelBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(LootrRegistry.getBarrelBlockEntity(), pWorldPosition, pBlockState);
    }

    @Override
    public LootrBlockType getInfoBlockType() {
        return LootrBlockType.BARREL;
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        if (this.infoId == null) {
            this.infoId = UUID.randomUUID();
        }
        return this.infoId;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return this.getBlockState().hasProperty((Property)BarrelBlock.OPEN) && (Boolean)this.getBlockState().getValue((Property)BarrelBlock.OPEN) != false;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
    }

    public void unpackLootTable(@Nullable Player player) {
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tryLoadLootTable(compound);
        if (compound.hasUUID("LootrId")) {
            this.infoId = compound.getUUID("LootrId");
        }
        if (compound.contains("LootrHasBeenOpened", 1)) {
            this.hasBeenOpened = compound.getBoolean("LootrHasBeenOpened");
        }
        if (this.infoId == null) {
            this.getInfoUUID();
        }
        this.clientOpeners.clear();
        if (compound.contains("LootrOpeners")) {
            ListTag list = compound.getList("LootrOpeners", 11);
            for (Tag thisTag : list) {
                this.clientOpeners.add(NbtUtils.loadUUID((Tag)thisTag));
            }
        }
    }

    public void saveToItem(ItemStack itemstack, HolderLookup.Provider provider) {
        this.savingToItem = true;
        super.saveToItem(itemstack, provider);
        this.savingToItem = false;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.trySaveLootTable(compound);
        if (!LootrAPI.shouldDiscard() && !this.savingToItem) {
            compound.putUUID("LootrId", this.getInfoUUID());
        }
        compound.putBoolean("LootrHasBeenOpened", this.hasBeenOpened);
        if (this.level != null && this.level.isClientSide() && this.clientOpeners != null && !this.clientOpeners.isEmpty()) {
            ListTag list = new ListTag();
            for (UUID opener : this.clientOpeners) {
                list.add((Object)NbtUtils.createUUID((UUID)opener));
            }
            compound.put("LootrOpeners", (Tag)list);
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.barrel");
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return null;
    }

    public int getContainerSize() {
        return 27;
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void updateBlockState(BlockState pState, boolean pOpen) {
        this.level.setBlock(this.getBlockPos(), (BlockState)pState.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    protected void playSound(BlockState pState, SoundEvent pSound) {
        Vec3i vec3i = ((Direction)pState.getValue((Property)BarrelBlock.FACING)).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void markChanged() {
        this.setChanged();
        this.markDataChanged();
    }

    @Override
    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    @Override
    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.clientOpeners;
    }

    @Override
    public boolean isClientOpened() {
        return this.clientOpened;
    }

    @Override
    public void setClientOpened(boolean opened) {
        this.clientOpened = opened;
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag result = super.getUpdateTag(provider);
        this.saveAdditional(result, provider);
        Set currentOpeners = this.getVisualOpeners();
        if (currentOpeners != null && !currentOpeners.isEmpty()) {
            ListTag list = new ListTag();
            for (UUID opener : Sets.intersection((Set)currentOpeners, LootrAPI.getPlayerIds())) {
                list.add((Object)NbtUtils.createUUID((UUID)opener));
            }
            if (!list.isEmpty()) {
                result.put("LootrOpeners", (Tag)list);
            }
        }
        return result;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    @Override
    @NotNull
    public BlockPos getInfoPos() {
        return this.getBlockPos();
    }

    @Override
    public ResourceKey<LootTable> getInfoLootTable() {
        return this.getLootTable();
    }

    @Override
    @Nullable
    public Component getInfoDisplayName() {
        return this.getDisplayName();
    }

    @Override
    @NotNull
    public ResourceKey<Level> getInfoDimension() {
        return this.getLevel().dimension();
    }

    @Override
    public int getInfoContainerSize() {
        return this.getContainerSize();
    }

    @Override
    public long getInfoLootSeed() {
        return this.getLootTableSeed();
    }

    @Override
    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory() {
        return null;
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return false;
    }

    @Override
    public Level getInfoLevel() {
        return this.getLevel();
    }

    @Override
    @Nullable
    public IContainerTrigger getTrigger() {
        return LootrRegistry.getBarrelTrigger();
    }

    @Override
    public String getInfoKey() {
        if (this.cachedId == null) {
            this.cachedId = ILootrInfo.generateInfoKey(this.getInfoUUID());
        }
        return this.cachedId;
    }

    @Override
    public int getPhysicalOpenerCount() {
        return this.openersCounter.getOpenerCount();
    }

    public static class DefaultBlockEntityConverter
    implements ILootrBlockEntityConverter<LootrBarrelBlockEntity> {
        @Override
        public ILootrBlockEntity apply(LootrBarrelBlockEntity blockEntity) {
            return blockEntity;
        }

        @Override
        public BlockEntityType<?> getBlockEntityType() {
            return LootrRegistry.getBarrelBlockEntity();
        }
    }
}

