/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.mixin.ticker;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrConstants;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.entity.ILootrEntity;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.common.entity.LootrItemFrame;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PersistentEntitySectionManager.class})
public class MixinPersistentEntitySectionManager {
    @Inject(method={"addEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void LootrAddEntity(EntityAccess entityAccess, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel level;
        if (LootrAPI.isDisabled()) {
            return;
        }
        if (!(entityAccess instanceof Entity)) {
            return;
        }
        Entity entity = (Entity)entityAccess;
        Level level2 = entity.level();
        if (!(level2 instanceof ServerLevel) || (level = (ServerLevel)level2).isClientSide()) {
            return;
        }
        if (LootrAPI.isDimensionBlocked((ResourceKey<Level>)level.dimension())) {
            return;
        }
        if (LootrAPI.shouldConvertStructureItemFrames() && entity.getType().is(LootrTags.Entity.CONVERT_ITEM_FRAMES) && entity.getTags().contains(LootrConstants.CAN_CONVERT_TAG)) {
            ItemStack contained;
            adapter = LootrAPI.getItemFrameAdapter(entity);
            if (adapter == null) {
                LootrAPI.LOG.error("No item frame adapter found for entity '{}' even though it is tagged for conversion.", (Object)entity);
                return;
            }
            if (!(adapter.isFixed(entity) || adapter.isInvisible(entity) || (contained = adapter.getItem(entity)).isEmpty() || contained.is(LootrTags.Items.ITEM_FRAME_CONVERT_BLACKLIST))) {
                LootrItemFrame newItemFrame = new LootrItemFrame((Level)level.getLevel(), adapter.getPos(entity), adapter.getDirection(entity));
                newItemFrame.lootrSetItem(contained);
                PlatformAPI.copyEntityData(adapter, entity, (ILootrEntity)newItemFrame);
                cir.setReturnValue((Object)false);
                cir.cancel();
                level.getServer().execute(() -> level.addFreshEntity((Entity)newItemFrame));
            }
        } else if (entity.getType().is(LootrTags.Entity.CONVERT_ENTITIES) && !entity.getType().is(LootrTags.Entity.CONVERT_BLACKLIST)) {
            adapter = LootrAPI.getAdapter(entity);
            if (adapter == null) {
                LootrAPI.LOG.error("No adapter found for entity '{}' even though it is tagged for conversion.", (Object)entity);
                return;
            }
            ResourceKey<LootTable> lootTable = adapter.getLootTable(entity);
            if (lootTable == null || LootrAPI.isLootTableBlacklisted(lootTable)) {
                return;
            }
            long seed = adapter.getLootSeed(entity);
            LootrAPI.preProcess(level, entity, lootTable, seed);
            LootrChestMinecartEntity lootrCart = new LootrChestMinecartEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ());
            PlatformAPI.copyEntityData(adapter, entity, (ILootrEntity)lootrCart);
            LootrAPI.postProcess(level, (Entity)lootrCart, lootTable, seed);
            cir.setReturnValue((Object)false);
            cir.cancel();
            level.getServer().execute(() -> level.addFreshEntity((Entity)lootrCart));
        }
    }
}

