/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.config;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.config.SaveMode;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.config.ConfigManagerBase;
import noobanidus.mods.lootr.common.impl.LootrServiceRegistry;

@Config(name="lootr")
public class ConfigManager
extends ConfigManagerBase
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private static final List<Identifier> PROBLEMATIC_CHESTS = Arrays.asList(Identifier.fromNamespaceAndPath((String)"atum", (String)"chests/pharaoh"), Identifier.fromNamespaceAndPath((String)"twilightforest", (String)"structures/stronghold_boss"));
    @ConfigEntry.Gui.Excluded
    private static Set<String> DECAY_MODS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<ResourceKey<LootTable>> DECAY_TABLES = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> REFRESH_MODS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<ResourceKey<LootTable>> REFRESH_TABLES = null;
    @ConfigEntry.Gui.Excluded
    private static Set<ResourceKey<Level>> DIM_WHITELIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> MODID_DIM_WHITELIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<ResourceKey<Level>> DIM_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> MODID_DIM_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<ResourceKey<Level>> DECAY_DIMS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<ResourceKey<Level>> REFRESH_DIMS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<ResourceKey<LootTable>> LOOT_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> LOOT_MODIDS = null;
    @ConfigEntry.Gui.CollapsibleObject
    public Debug debug = new Debug();
    @ConfigEntry.Gui.CollapsibleObject
    public Seed seed = new Seed();
    @ConfigEntry.Gui.CollapsibleObject
    public Conversion conversion = new Conversion();
    @ConfigEntry.Gui.CollapsibleObject
    public Breaking breaking = new Breaking();
    @ConfigEntry.Gui.CollapsibleObject
    public Lists lists = new Lists();
    @ConfigEntry.Gui.CollapsibleObject
    public Decay decay = new Decay();
    @ConfigEntry.Gui.CollapsibleObject
    public Refresh refresh = new Refresh();
    @ConfigEntry.Gui.CollapsibleObject
    public Notifications notifications = new Notifications();
    @ConfigEntry.Gui.CollapsibleObject
    public Client client = new Client();

    public static void reset() {
        LootrServiceRegistry.clearReplacements();
        MODID_DIM_WHITELIST = null;
        MODID_DIM_BLACKLIST = null;
        DIM_WHITELIST = null;
        DIM_BLACKLIST = null;
        LOOT_BLACKLIST = null;
        DECAY_MODS = null;
        DECAY_TABLES = null;
        DECAY_DIMS = null;
        LOOT_MODIDS = null;
        REFRESH_DIMS = null;
        REFRESH_MODS = null;
        REFRESH_TABLES = null;
        LootrAPI.refreshSections();
    }

    public static ConfigManager get() {
        return (ConfigManager)AutoConfig.getConfigHolder(ConfigManager.class).getConfig();
    }

    public static Set<ResourceKey<Level>> getDimensionWhitelist() {
        if (DIM_WHITELIST == null) {
            DIM_WHITELIST = ConfigManager.validateDimensions(ConfigManager.get().lists.dimension_whitelist, "dimension_whitelist");
        }
        return DIM_WHITELIST;
    }

    public static Set<String> getDimensionModidWhitelist() {
        if (MODID_DIM_WHITELIST == null) {
            MODID_DIM_WHITELIST = ConfigManager.validateStringList(ConfigManager.get().lists.modid_dimension_whitelist, "modid_dimension_whitelist");
        }
        return MODID_DIM_WHITELIST;
    }

    public static Set<ResourceKey<Level>> getDimensionBlacklist() {
        if (DIM_BLACKLIST == null) {
            DIM_BLACKLIST = ConfigManager.validateDimensions(ConfigManager.get().lists.dimension_blacklist, "dimension_blacklist");
        }
        return DIM_BLACKLIST;
    }

    public static Set<String> getDimensionModidBlacklist() {
        if (MODID_DIM_BLACKLIST == null) {
            MODID_DIM_BLACKLIST = ConfigManager.validateStringList(ConfigManager.get().lists.modid_dimension_blacklist, "modid_dimension_blacklist");
        }
        return MODID_DIM_BLACKLIST;
    }

    public static Set<ResourceKey<Level>> getDecayDimensions() {
        if (DECAY_DIMS == null) {
            DECAY_DIMS = ConfigManager.validateDimensions(ConfigManager.get().decay.decay_dimensions, "decay_dimensions");
        }
        return DECAY_DIMS;
    }

    public static Set<ResourceKey<Level>> getRefreshDimensions() {
        if (REFRESH_DIMS == null) {
            REFRESH_DIMS = ConfigManager.validateDimensions(ConfigManager.get().refresh.refresh_dimensions, "refresh_dimensions");
        }
        return REFRESH_DIMS;
    }

    public static Set<ResourceKey<LootTable>> getLootBlacklist() {
        if (LOOT_BLACKLIST == null) {
            LOOT_BLACKLIST = ConfigManager.validateResourceKeyList(ConfigManager.get().lists.loot_table_blacklist, "loot_blacklist", o -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)o));
            PROBLEMATIC_CHESTS.forEach(o -> LOOT_BLACKLIST.add((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)o)));
        }
        return LOOT_BLACKLIST;
    }

    public static Set<String> getLootModidsBlacklist() {
        if (LOOT_MODIDS == null) {
            LOOT_MODIDS = ConfigManager.validateStringList(ConfigManager.get().lists.loot_modid_blacklist, "loot_modid_blacklist");
        }
        return LOOT_MODIDS;
    }

    public static boolean isBlacklisted(ResourceKey<LootTable> table) {
        if (ConfigManager.getLootBlacklist().contains(table)) {
            return true;
        }
        return ConfigManager.getLootModidsBlacklist().contains(table.identifier().getNamespace());
    }

    public static Set<ResourceKey<LootTable>> getDecayingTables() {
        if (DECAY_TABLES == null) {
            DECAY_TABLES = ConfigManager.validateResourceKeyList(ConfigManager.get().decay.decay_loot_tables, "decay_loot_tables", o -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)o));
        }
        return DECAY_TABLES;
    }

    public static Set<String> getDecayMods() {
        if (DECAY_MODS == null) {
            DECAY_MODS = ConfigManager.validateStringList(ConfigManager.get().decay.decay_modids, "decay_mods");
        }
        return DECAY_MODS;
    }

    public static Set<ResourceKey<LootTable>> getRefreshingTables() {
        if (REFRESH_TABLES == null) {
            REFRESH_TABLES = ConfigManager.validateResourceKeyList(ConfigManager.get().refresh.refresh_loot_tables, "refresh_tables", o -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)o));
        }
        return REFRESH_TABLES;
    }

    public static Set<String> getRefreshMods() {
        if (REFRESH_MODS == null) {
            REFRESH_MODS = ConfigManager.validateStringList(ConfigManager.get().refresh.refresh_modids, "refresh_modids");
        }
        return REFRESH_MODS;
    }

    public static boolean isDimensionBlocked(ResourceKey<Level> key) {
        if (!ConfigManager.getDimensionModidWhitelist().isEmpty() && !ConfigManager.getDimensionModidWhitelist().contains(key.identifier().getNamespace()) || ConfigManager.getDimensionModidBlacklist().contains(key.identifier().getNamespace())) {
            return true;
        }
        return !ConfigManager.getDimensionWhitelist().isEmpty() && !ConfigManager.getDimensionWhitelist().contains(key) || ConfigManager.getDimensionBlacklist().contains(key);
    }

    public static boolean isDimensionDecaying(ResourceKey<Level> key) {
        return ConfigManager.getDecayDimensions().contains(key);
    }

    public static boolean isDimensionRefreshing(ResourceKey<Level> key) {
        return ConfigManager.getRefreshDimensions().contains(key);
    }

    public static boolean isDecaying(ILootrInfoProvider tile) {
        if (ConfigManager.get().decay.decay_all) {
            return true;
        }
        if (tile.getInfoLootTable() != null) {
            if (ConfigManager.getDecayingTables().contains(tile.getInfoLootTable())) {
                return true;
            }
            if (ConfigManager.getDecayMods().contains(tile.getInfoLootTable().identifier().getNamespace())) {
                return true;
            }
        }
        if (LootrAPI.isTaggedStructurePresent((ServerLevel)tile.getInfoLevel(), new ChunkPos(tile.getInfoPos()), LootrTags.Structure.DECAY_STRUCTURES, tile.getInfoPos())) {
            return true;
        }
        return ConfigManager.isDimensionDecaying(tile.getInfoDimension());
    }

    public static boolean isRefreshing(ILootrInfoProvider tile) {
        if (ConfigManager.get().refresh.refresh_all) {
            return true;
        }
        if (tile.getInfoLootTable() != null) {
            if (ConfigManager.getRefreshingTables().contains(tile.getInfoLootTable())) {
                return true;
            }
            if (ConfigManager.getRefreshMods().contains(tile.getInfoLootTable().identifier().getNamespace())) {
                return true;
            }
        }
        if (LootrAPI.isTaggedStructurePresent((ServerLevel)tile.getInfoLevel(), new ChunkPos(tile.getInfoPos()), LootrTags.Structure.REFRESH_STRUCTURES, tile.getInfoPos())) {
            return true;
        }
        return ConfigManager.isDimensionRefreshing(tile.getInfoDimension());
    }

    public static boolean shouldNotify(int remaining) {
        int delay = ConfigManager.get().notifications.notification_delay;
        return !ConfigManager.get().notifications.disable_notifications && (delay == -1 || remaining <= delay);
    }

    public static boolean shouldPerformPiecewiseCheck() {
        return ConfigManager.get().conversion.perform_piecewise_check;
    }

    public static boolean isVanillaTextures() {
        return ConfigManager.get().client.vanilla_textures;
    }

    public static boolean isNewTextures() {
        return true;
    }

    public static class Debug {
        public boolean report_unresolved_tables = true;
    }

    public static class Seed {
        public boolean randomize_seed = true;
    }

    public static class Conversion {
        public boolean disable = false;
        public boolean convert_elytras_to_chests = false;
        public boolean convert_elytras_to_item_frames = true;
        @Deprecated
        public boolean convert_mineshafts = true;
        public boolean convert_structure_item_frames = true;
        public boolean world_border = false;
        public boolean perform_piecewise_check = true;
        public boolean bypass_spawn_protection = true;
        public boolean skip_logging_no_loot_table_at_generation = true;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public SaveMode save_mode = SaveMode.SMART;
    }

    public static class Breaking {
        public boolean disable_break = false;
        public boolean enable_break = false;
        public boolean enable_fake_player_break = false;
        public boolean power_comparators = true;
        public boolean blast_resistant = false;
        public boolean blast_immune = false;
        public boolean trapped_custom = false;
        public boolean should_drop_player_loot = false;
        public boolean brushables_self_support = false;
        public boolean item_frames_self_support = false;
    }

    public static class Lists {
        public List<String> dimension_whitelist = List.of();
        public List<String> dimension_blacklist = List.of();
        public List<String> loot_table_blacklist = List.of();
        public List<String> loot_modid_blacklist = List.of();
        public List<String> modid_dimension_whitelist = List.of();
        public List<String> modid_dimension_blacklist = List.of();
    }

    public static class Decay {
        public int decay_value = 6000;
        public boolean decay_all = false;
        @ConfigEntry.Gui.RequiresRestart
        public boolean perform_tick_decay = true;
        @ConfigEntry.Gui.RequiresRestart
        public boolean start_tick_decay = false;
        public List<String> decay_modids = List.of();
        public List<String> decay_loot_tables = List.of();
        public List<String> decay_dimensions = List.of();
        public boolean replace_when_decayed = false;
    }

    public static class Refresh {
        public int refresh_value = 24000;
        public boolean refresh_all = false;
        @ConfigEntry.Gui.RequiresRestart
        public boolean perform_tick_refresh = true;
        @ConfigEntry.Gui.RequiresRestart
        public boolean start_tick_refresh = true;
        public List<String> refresh_modids = List.of();
        public List<String> refresh_loot_tables = List.of();
        public List<String> refresh_dimensions = List.of();
    }

    public static class Notifications {
        public int notification_delay = 600;
        public boolean disable_notifications = false;
        public boolean disable_message_styles = false;
    }

    public static class Client {
        public boolean vanilla_textures = false;
        public boolean unopened_particles = true;
    }
}

