/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.client.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.model.loading.v1.CustomUnbakedBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import noobanidus.mods.lootr.common.client.block.UnbakedBrushableModel;
import org.jspecify.annotations.Nullable;

public class UnbakedBrushableModel
extends noobanidus.mods.lootr.common.client.block.UnbakedBrushableModel
implements CustomUnbakedBlockStateModel {
    public static final MapCodec<UnbakedBrushableModel> CODEC = UnbakedBrushableModel.getCodec(UnbakedBrushableModel::new);

    public UnbakedBrushableModel(Identifier opened, Identifier stage_0, Identifier stage_1, Identifier stage_2, Identifier stage_3, Variant.SimpleModelState state) {
        super(opened, stage_0, stage_1, stage_2, stage_3, state);
    }

    public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
        return CODEC;
    }

    @Override
    protected UnbakedBrushableModel.Baker getBaker() {
        return Baked::new;
    }

    public static class Baked
    extends UnbakedBrushableModel.Baked {
        public Baked(BlockStateModel opened, BlockStateModel stage_0, BlockStateModel stage_1, BlockStateModel stage_2, BlockStateModel stage_3) {
            super(opened, stage_0, stage_1, stage_2, stage_3);
        }

        @Override
        protected boolean isOpenFromBATG(BlockAndTintGetter level, BlockPos pos, BlockState state, @Nullable RandomSource random) {
            return level.getBlockEntityRenderData(pos) == Boolean.TRUE;
        }

        public void emitQuads(QuadEmitter emitter, BlockAndTintGetter blockView, BlockPos pos, BlockState state, RandomSource random, Predicate<@Nullable Direction> cullTest) {
            boolean visuallyOpen = this.isOpenFromBATG(blockView, pos, state, random);
            if (visuallyOpen) {
                this.opened.emitQuads(emitter, blockView, pos, state, random, cullTest);
            } else {
                switch ((Integer)state.getValue((Property)BlockStateProperties.DUSTED)) {
                    case 1: {
                        this.stage_1.emitQuads(emitter, blockView, pos, state, random, cullTest);
                        break;
                    }
                    case 2: {
                        this.stage_2.emitQuads(emitter, blockView, pos, state, random, cullTest);
                        break;
                    }
                    case 3: {
                        this.stage_3.emitQuads(emitter, blockView, pos, state, random, cullTest);
                        break;
                    }
                    default: {
                        this.stage_0.emitQuads(emitter, blockView, pos, state, random, cullTest);
                    }
                }
            }
        }

        public @Nullable Object createGeometryKey(BlockAndTintGetter blockView, BlockPos pos, BlockState state, RandomSource random) {
            return this.internalCreateObjectKey(blockView, pos, state, random);
        }

        public TextureAtlasSprite particleSprite(BlockAndTintGetter blockView, BlockPos pos, BlockState state) {
            if (this.isOpenFromBATG(blockView, pos, state, null)) {
                return this.opened.particleSprite(blockView, pos, state);
            }
            return switch ((Integer)state.getValue((Property)BlockStateProperties.DUSTED)) {
                case 1 -> this.stage_1.particleSprite(blockView, pos, state);
                case 2 -> this.stage_2.particleSprite(blockView, pos, state);
                case 3 -> this.stage_3.particleSprite(blockView, pos, state);
                default -> this.stage_0.particleSprite(blockView, pos, state);
            };
        }
    }
}

