/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinBlock;
import org.jetbrains.annotations.Nullable;

public class ClientHooks {
    @Nullable
    public static Player getPlayer() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return null;
        }
        return mc.player;
    }

    public static void clearCache(BlockPos position) {
        SectionPos pos = SectionPos.of((BlockPos)position);
        Minecraft.getInstance().submit(() -> Minecraft.getInstance().levelRenderer.setSectionDirty(pos.x(), pos.y(), pos.z()));
    }

    public static void refreshSection() {
        Player player = ClientHooks.getPlayer();
        if (player != null) {
            ClientHooks.clearCache(player.blockPosition());
        }
    }

    public static void performBreakEffect(int entityId, BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        Entity entity = mc.level.getEntity(entityId);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        double offset = 1.2;
        if (player == mc.player) {
            BlockState state = mc.level.getBlockState(pos);
            ((AccessorMixinBlock)state.getBlock()).lootr$spawnDestroyParticles((Level)mc.level, player, pos, state);
            mc.level.playSound(null, pos, SoundEvents.DECORATED_POT_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            ILootrBlockEntity ibe;
            BlockEntity blockEntity = mc.level.getBlockEntity(pos);
            if (blockEntity instanceof ILootrBlockEntity && (ibe = (ILootrBlockEntity)blockEntity).hasClientOpened((Player)mc.player)) {
                offset = 0.5;
            }
            mc.level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 7; ++i) {
                mc.level.addParticle((ParticleOptions)ParticleTypes.DUST_PLUME, false, false, (double)pos.getX() + 0.5, (double)pos.getY() + offset, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    private static double bounded(RandomSource random, double[] bounds) {
        double min = bounds[0];
        double max = bounds[1];
        return min + random.nextDouble() * (max - min);
    }

    public static void performUnopenedParticles(ILootrInfoProvider provider) {
        RandomSource random;
        ClientLevel level;
        Player player = ClientHooks.getPlayer();
        if (player != null && (level = Minecraft.getInstance().level) != null && !provider.hasClientOpened(player) && (random = Minecraft.getInstance().level.getRandom()).nextInt(3) == 0) {
            double xOff = ClientHooks.bounded(random, provider.getParticleXBounds());
            double zOff = ClientHooks.bounded(random, provider.getParticleZBounds());
            Vec3 pos = provider.getParticleCenter();
            level.addParticle((ParticleOptions)LootrRegistry.getUnopenedParticleType(), pos.x + xOff, pos.y + provider.getParticleYOffset() + random.nextDouble() * 0.02, pos.z + zOff, 0.0, random.nextDouble() * 0.02, 0.0);
        }
    }
}

