/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SimpleLootrInstance {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected NonNullList<ItemStack> items;
    protected NonNullList<ItemStack> referenceInventory = null;
    protected final Set<UUID> clientOpeners = new ObjectOpenHashSet();
    protected UUID infoId = null;
    protected boolean hasBeenOpened = false;
    protected String cachedId;
    protected boolean clientOpened = false;
    protected boolean providesOwnUuid = false;
    protected final Supplier<Set<UUID>> visualOpenersSupplier;

    public SimpleLootrInstance(Supplier<Set<UUID>> visualOpenersSupplier, int size) {
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        this.visualOpenersSupplier = visualOpenersSupplier;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setReferenceInventory(NonNullList<ItemStack> items) {
        this.referenceInventory = items;
    }

    public NonNullList<ItemStack> getReferenceInventory() {
        return this.referenceInventory;
    }

    public Set<UUID> getClientOpeners() {
        return this.clientOpeners;
    }

    public boolean isClientOpened() {
        return this.clientOpened;
    }

    public void setClientOpened(boolean opened) {
        this.clientOpened = opened;
    }

    @NotNull
    public UUID getInfoUUID() {
        if (this.providesOwnUuid) {
            throw new IllegalStateException("This instance provides its own UUID but hasn't overriden `getInfoUUID`: " + String.valueOf(this));
        }
        if (this.infoId == null) {
            this.infoId = UUID.randomUUID();
        }
        return this.infoId;
    }

    public String getInfoKey() {
        if (this.cachedId == null) {
            this.cachedId = ILootrInfo.generateInfoKey(this.getInfoUUID());
        }
        return this.cachedId;
    }

    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    public int getInfoContainerSize() {
        return this.items.size();
    }

    public void setHasBeenOpened() {
        this.hasBeenOpened = true;
    }

    public void loadAdditional(ValueInput input) {
        if (!this.providesOwnUuid) {
            this.infoId = input.read("LootrId", UUIDUtil.CODEC).orElse(null);
        }
        this.hasBeenOpened = input.getBooleanOr("LootrHasBeenOpened", false);
        if (this.infoId == null && !this.providesOwnUuid) {
            this.getInfoUUID();
        }
        this.clientOpeners.clear();
        input.read("LootrOpeners", UUIDUtil.CODEC_SET).map(this.clientOpeners::addAll);
        if (input.getBooleanOr("isCustomInventory", false)) {
            if (this.referenceInventory == null) {
                this.referenceInventory = NonNullList.withSize((int)this.getInfoContainerSize(), (Object)ItemStack.EMPTY);
            }
            ContainerHelper.loadAllItems((ValueInput)input, this.referenceInventory);
        }
    }

    public void saveAdditional(ValueOutput output, boolean isClientSide) {
        if (!LootrAPI.shouldDiscard() && !this.providesOwnUuid) {
            output.store("LootrId", UUIDUtil.CODEC, (Object)this.getInfoUUID());
        }
        output.putBoolean("LootrHasBeenOpened", this.hasBeenOpened);
        if (isClientSide && !this.clientOpeners.isEmpty()) {
            output.store("LootrOpeners", UUIDUtil.CODEC_SET, this.clientOpeners);
        }
        if (this.referenceInventory != null) {
            output.putBoolean("isCustomInventory", true);
            ContainerHelper.saveAllItems((ValueOutput)output, this.referenceInventory);
        } else {
            output.putBoolean("isCustomInventory", false);
        }
    }

    public CompoundTag fillUpdateTag(HolderLookup.Provider provider, boolean isClientSide, BlockEntity parent) {
        try (ProblemReporter.ScopedCollector p = new ProblemReporter.ScopedCollector(LOGGER);){
            ProblemReporter p2 = p.forChild(parent.problemPath());
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)p2, (HolderLookup.Provider)provider);
            this.saveAdditional((ValueOutput)output, isClientSide);
            if (!isClientSide) {
                Sets.SetView currentOpeners = Sets.intersection(this.visualOpenersSupplier.get(), LootrAPI.getPlayerIds());
                output.store("LootrOpeners", UUIDUtil.CODEC_SET, (Object)currentOpeners);
            } else {
                LootrAPI.LOG.error("Tried to fillUpdateTag on the client side for SimpleLootrInstance: {}", (Object)this);
            }
            CompoundTag compoundTag = output.buildResult();
            return compoundTag;
        }
    }

    public boolean isReferenceInventory() {
        return this.referenceInventory != null && !this.referenceInventory.isEmpty();
    }
}

