/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLootFiller
implements LootFiller {
    private static final DefaultLootFiller INSTANCE = new DefaultLootFiller();
    private static LootFiller.LootFillerState state = null;

    public static DefaultLootFiller getInstance() {
        return INSTANCE;
    }

    @Nullable
    public static LootFiller.LootFillerState getFillerState() {
        return state;
    }

    @Override
    public void unpackLootTable(ILootrInfoProvider provider, @NotNull Player player, Container inventory) {
        Level level = provider.getInfoLevel();
        if (level == null || level.isClientSide() || level.getServer() == null) {
            LootrAPI.LOG.error("Unable to fill loot container as the level is null, client-side, or the server is null!");
            return;
        }
        BlockPos pos = provider.getInfoPos();
        ResourceKey<LootTable> lootTable = provider.getInfoLootTable();
        if (provider.isInfoReferenceInventory() && provider.getInfoReferenceInventory() != null) {
            for (int i = 0; i < provider.getInfoReferenceInventory().size(); ++i) {
                inventory.setItem(i, ((ItemStack)provider.getInfoReferenceInventory().get(i)).copy());
            }
        } else if (lootTable == null) {
            LootrAPI.LOG.error("Unable to fill loot container in {} at {} as the loot table is null and the provider is not a reference inventory!", (Object)level.dimension().identifier(), (Object)pos);
        } else {
            long seed = LootrAPI.getLootSeed(provider.getInfoLootSeed());
            LootTable loottable = level.getServer().reloadableRegistries().getLootTable(lootTable);
            if (loottable == LootTable.EMPTY) {
                LootrAPI.LOG.error("Unable to fill loot container in {} at {} as the loot table '{}' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.", (Object)level.dimension().identifier(), (Object)pos, (Object)lootTable.identifier());
                if (LootrAPI.reportUnresolvedTables()) {
                    player.displayClientMessage(LootrAPI.getInvalidTableComponent(lootTable), false);
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                CriteriaTriggers.GENERATE_LOOT.trigger(sPlayer, lootTable);
            }
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)provider.getInfoVec()).withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
            this.fill(provider, player, lootTable, loottable, inventory, builder.create(LootContextParamSets.CHEST), seed);
        }
    }

    public static void performFill(ILootrInfoProvider provider, Player player, ResourceKey<LootTable> lootTableKey, LootTable lootTable, Container container, LootParams parameters, long seed) {
        DefaultLootFiller.setFillerState(new LootFiller.LootFillerState(provider, player, lootTableKey, lootTable, container, parameters, seed));
        lootTable.fill(container, parameters, seed);
        DefaultLootFiller.setFillerState(null);
    }

    public static void setFillerState(@Nullable LootFiller.LootFillerState newState) {
        state = newState;
    }
}

