/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.mixins;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecartContainer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.entity.EntityTicker;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.fabric.init.ModTicketTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PersistentEntitySectionManager.class})
public class MixinPersistentEntitySectionManager {
    @Inject(method={"addEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void LootrAddEntity(EntityAccess entityAccess, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        AbstractMinecartContainer cart;
        ServerLevel level;
        if (LootrAPI.isDisabled()) {
            return;
        }
        if (!(entityAccess instanceof Entity)) {
            return;
        }
        Entity entity = (Entity)entityAccess;
        Level level2 = entity.level();
        if (!(level2 instanceof ServerLevel) || (level = (ServerLevel)level2).isClientSide()) {
            return;
        }
        if (LootrAPI.isDimensionBlocked((ResourceKey<Level>)level.dimension())) {
            return;
        }
        if (entity.getType().is(LootrTags.Entity.CONVERT_BLACKLIST)) {
            return;
        }
        if (entity.getType().is(LootrTags.Entity.CONVERT_ENTITIES) && entity instanceof AbstractMinecartContainer && (cart = (AbstractMinecartContainer)entity).getContainerLootTable() != null && !LootrAPI.isLootTableBlacklisted((ResourceKey<LootTable>)cart.getContainerLootTable())) {
            LootrChestMinecartEntity lootrCart = new LootrChestMinecartEntity(LootrRegistry.getMinecart(), cart.level());
            lootrCart.setPos(cart.getX(), cart.getY(), cart.getZ());
            PlatformAPI.copyEntityData(cart, lootrCart);
            cir.setReturnValue((Object)false);
            cir.cancel();
            if (!level.getServer().isSameThread()) {
                level.getServer().execute(() -> level.getChunkSource().addTicket(new Ticket(ModTicketTypes.ENTITY_TICKET_TYPE, ChunkMap.FORCED_TICKET_LEVEL), lootrCart.chunkPosition()));
                LootrAPI.LOG.error("Minecart with Loot table created off main thread. Falling back on EntityTicker.");
                EntityTicker.addEntity(lootrCart);
            } else {
                level.addFreshEntity((Entity)lootrCart);
            }
        }
    }
}

