/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.init;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.block.LootrChestBlock;
import noobanidus.mods.lootr.common.block.LootrInventoryBlock;
import noobanidus.mods.lootr.common.block.LootrShulkerBlock;
import noobanidus.mods.lootr.common.block.LootrTrappedChestBlock;
import noobanidus.mods.lootr.common.block.TrophyBlock;
import noobanidus.mods.lootr.common.block.entity.LootrShulkerBlockEntity;
import noobanidus.mods.lootr.fabric.block.LootrFabricBarrelBlock;

public class ModBlocks {
    public static final LootrChestBlock CHEST = new LootrChestBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST).strength(2.5f).setId(LootrRegistry.CHEST_BLOCK_KEY));
    public static final LootrFabricBarrelBlock BARREL = new LootrFabricBarrelBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL).strength(2.5f).forceSolidOff().setId(LootrRegistry.BARREL_BLOCK_KEY));
    public static final LootrTrappedChestBlock TRAPPED_CHEST = new LootrTrappedChestBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TRAPPED_CHEST).strength(2.5f).setId(LootrRegistry.TRAPPED_CHEST_BLOCK_KEY));
    public static final LootrInventoryBlock INVENTORY = new LootrInventoryBlock(BlockBehaviour.Properties.of().strength(2.5f).sound(SoundType.WOOD).setId(LootrRegistry.INVENTORY_BLOCK_KEY));
    public static final Block TROPHY = new TrophyBlock(BlockBehaviour.Properties.of().strength(15.0f).sound(SoundType.METAL).noOcclusion().lightLevel(o -> 15).setId(LootrRegistry.TROPHY_BLOCK_KEY));
    private static final BlockBehaviour.StatePredicate posPredicate = (state, level, pos) -> {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LootrShulkerBlockEntity) {
            LootrShulkerBlockEntity shulkerBlockEntity = (LootrShulkerBlockEntity)blockEntity;
            return shulkerBlockEntity.isClosed();
        }
        return false;
    };
    public static final LootrShulkerBlock SHULKER = new LootrShulkerBlock(BlockBehaviour.Properties.of().strength(2.5f).dynamicShape().noOcclusion().isSuffocating(posPredicate).isViewBlocking(posPredicate).setId(LootrRegistry.SHULKER_BLOCK_KEY));

    public static void registerBlocks() {
        Registry.register((Registry)BuiltInRegistries.BLOCK, (Identifier)LootrRegistry.CHEST, (Object)((Object)CHEST));
        Registry.register((Registry)BuiltInRegistries.BLOCK, (Identifier)LootrRegistry.BARREL, (Object)((Object)BARREL));
        Registry.register((Registry)BuiltInRegistries.BLOCK, (Identifier)LootrRegistry.TRAPPED_CHEST, (Object)((Object)TRAPPED_CHEST));
        Registry.register((Registry)BuiltInRegistries.BLOCK, (Identifier)LootrRegistry.INVENTORY, (Object)((Object)INVENTORY));
        Registry.register((Registry)BuiltInRegistries.BLOCK, (Identifier)LootrRegistry.TROPHY, (Object)TROPHY);
        Registry.register((Registry)BuiltInRegistries.BLOCK, (Identifier)LootrRegistry.SHULKER, (Object)((Object)SHULKER));
    }
}

