/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import noobanidus.mods.lootr.common.api.advancement.ILootedStatTrigger;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;

public class LootedStatTrigger
extends SimpleCriterionTrigger<TriggerInstance>
implements ILootedStatTrigger {
    @Override
    public void trigger(ServerPlayer player) {
        this.trigger(player, instance -> instance.test(player));
    }

    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public static Criterion<TriggerInstance> looted(int count) {
        return ((LootedStatTrigger)LootrRegistry.getStatTrigger().getTrigger()).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), MinMaxBounds.Ints.exactly((int)count)));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints score) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("score", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::score)).apply((Applicative)codec, TriggerInstance::new));

        public boolean test(ServerPlayer player) {
            return this.score.matches(player.getStats().getValue(LootrRegistry.getLootedStat()));
        }
    }
}

