/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.client.ClientHooks;
import noobanidus.mods.lootr.common.client.entity.LootrBlockStateDefinitions;
import noobanidus.mods.lootr.common.client.state.LootrItemFrameRenderState;
import noobanidus.mods.lootr.common.entity.LootrItemFrame;
import org.joml.Quaternionfc;

public class LootrItemFrameRenderer
extends EntityRenderer<LootrItemFrame, LootrItemFrameRenderState> {
    private final ItemModelResolver itemModelResolver;
    private final BlockRenderDispatcher blockRenderer;

    public LootrItemFrameRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void submit(LootrItemFrameRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        float f1;
        float f;
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
        poseStack.pushPose();
        Direction direction = renderState.direction;
        Vec3 vec3 = this.getRenderOffset(renderState);
        poseStack.translate(-vec3.x(), -vec3.y(), -vec3.z());
        poseStack.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        if (direction.getAxis().isHorizontal()) {
            f = 0.0f;
            f1 = 180.0f - direction.toYRot();
        } else {
            f = -90 * direction.getAxisDirection().getStep();
            f1 = 180.0f;
        }
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f1));
        if (!renderState.isInvisible) {
            BlockState blockstate = LootrBlockStateDefinitions.getItemFrameFakeState(renderState);
            BlockStateModel blockstatemodel = this.blockRenderer.getBlockModel(blockstate);
            poseStack.pushPose();
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            nodeCollector.submitBlockModel(poseStack, RenderTypes.entitySolidZOffsetForward((Identifier)TextureAtlas.LOCATION_BLOCKS), blockstatemodel, 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.outlineColor);
            poseStack.popPose();
        }
        if (renderState.isInvisible) {
            poseStack.translate(0.0f, 0.0f, 0.5f);
        } else {
            poseStack.translate(0.0f, 0.0f, 0.4375f);
        }
        if (!renderState.item.isEmpty() && !renderState.visuallyOpen) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)renderState.rotation * 360.0f / 8.0f));
            int k = renderState.lightCoords;
            poseStack.scale(0.5f, 0.5f, 0.5f);
            renderState.item.submit(poseStack, nodeCollector, k, OverlayTexture.NO_OVERLAY, renderState.outlineColor);
        }
        poseStack.popPose();
    }

    public Vec3 getRenderOffset(LootrItemFrameRenderState renderState) {
        return new Vec3((double)((float)renderState.direction.getStepX() * 0.3f), -0.25, (double)((float)renderState.direction.getStepZ() * 0.3f));
    }

    protected boolean shouldShowName(LootrItemFrame entity, double distanceToCameraSq) {
        return Minecraft.renderNames() && this.entityRenderDispatcher.crosshairPickEntity == entity && entity.getItem().getCustomName() != null;
    }

    protected Component getNameTag(LootrItemFrame entity) {
        return entity.getItem().getHoverName();
    }

    public LootrItemFrameRenderState createRenderState() {
        return new LootrItemFrameRenderState();
    }

    public void extractRenderState(LootrItemFrame entity, LootrItemFrameRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.direction = entity.getDirection();
        ItemStack itemstack = entity.getItem();
        this.itemModelResolver.updateForNonLiving(reusedState.item, itemstack, ItemDisplayContext.FIXED, (Entity)entity);
        reusedState.rotation = entity.getRotation();
        reusedState.isGlowFrame = entity.getType() == EntityType.GLOW_ITEM_FRAME;
        reusedState.mapId = null;
        Player player = ClientHooks.getPlayer();
        reusedState.visuallyOpen = player == null ? false : entity.hasClientOpened(player);
        reusedState.vanilla = LootrAPI.isVanillaTextures();
    }
}

