/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.block.entity.LootrShulkerBlockEntity;
import org.jetbrains.annotations.Nullable;

public class LootrShulkerBlock
extends ShulkerBoxBlock {
    public LootrShulkerBlock(BlockBehaviour.Properties pProperties) {
        super(DyeColor.YELLOW, pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    private static boolean canOpen(BlockState pState, Level pLevel, BlockPos pPos, LootrShulkerBlockEntity pBlockEntity) {
        if (pBlockEntity.getAnimationStatus() != ShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB aabb = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)((Direction)pState.getValue((Property)FACING)), (float)0.0f, (float)0.5f, (Vec3)pPos.getBottomCenter()).deflate(1.0E-6);
        return pLevel.noCollision(aabb);
    }

    public float getExplosionResistance() {
        return LootrAPI.getExplosionResistance((Block)this, super.getExplosionResistance());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult trace) {
        if (level.isClientSide() || player.isSpectator() || !(player instanceof ServerPlayer)) {
            return InteractionResult.CONSUME;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof LootrShulkerBlockEntity)) {
            return InteractionResult.PASS;
        }
        LootrShulkerBlockEntity shulkerboxblockentity = (LootrShulkerBlockEntity)blockEntity;
        if (!LootrShulkerBlock.canOpen(state, level, pos, shulkerboxblockentity)) {
            return InteractionResult.PASS;
        }
        if (serverPlayer.isShiftKeyDown()) {
            LootrAPI.handleProviderSneak(ILootrInfoProvider.of(pos, level), serverPlayer);
        } else {
            LootrAPI.handleProviderOpen(ILootrInfoProvider.of(pos, level), serverPlayer);
            player.awardStat(Stats.OPEN_SHULKER_BOX);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        this.spawnDestroyParticles(pLevel, pPlayer, pPos, pState);
        if (pState.is(BlockTags.GUARDED_BY_PIGLINS) && pLevel instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)pLevel;
            PiglinAi.angerNearbyPiglins((ServerLevel)sLevel, (Player)pPlayer, (boolean)false);
        }
        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_DESTROY, pPos);
        return pState;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        return blockentity instanceof LootrShulkerBlockEntity ? Shapes.create((AABB)((LootrShulkerBlockEntity)blockentity).getBoundingBox(pState)) : Shapes.block();
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    @Nullable
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }

    public float getDestroyProgress(BlockState p_60466_, Player p_60467_, BlockGetter p_60468_, BlockPos p_60469_) {
        return LootrAPI.getDestroyProgress(p_60466_, p_60467_, p_60468_, p_60469_, super.getDestroyProgress(p_60466_, p_60467_, p_60468_, p_60469_));
    }

    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos, Direction direction) {
        return LootrAPI.getAnalogOutputSignal(pBlockState, pLevel, pPos, 0, direction);
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new LootrShulkerBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return ILootrBlockEntity::ticker;
    }

    public void playerDestroy(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.playerDestroy(level, player, blockPos, blockState, blockEntity, itemStack);
        LootrAPI.playerDestroyed(level, player, blockPos, blockEntity);
    }
}

