/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.client.block;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import noobanidus.mods.lootr.common.api.LootrAPI;
import org.jetbrains.annotations.Nullable;

public class CustomBarrelModel
implements UnbakedModel {
    private final UnbakedModel opened;
    private final UnbakedModel unopened;
    @Nullable
    private final UnbakedModel vanilla;
    private Collection<ResourceLocation> dependencies = null;

    public CustomBarrelModel(UnbakedModel opened, UnbakedModel unopened, @Nullable UnbakedModel vanilla) {
        this.opened = opened;
        this.unopened = unopened;
        this.vanilla = vanilla;
    }

    public Collection<ResourceLocation> getDependencies() {
        if (this.dependencies == null) {
            Stream deps = Streams.concat((Stream[])new Stream[]{this.opened.getDependencies().stream(), this.unopened.getDependencies().stream()});
            if (this.vanilla != null) {
                deps = Streams.concat((Stream[])new Stream[]{deps, this.vanilla.getDependencies().stream()});
            }
            this.dependencies = deps.collect(Collectors.toSet());
        }
        return this.dependencies;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> function) {
        this.opened.resolveParents(function);
        this.unopened.resolveParents(function);
        if (this.vanilla != null) {
            this.vanilla.resolveParents(function);
        }
    }

    @Nullable
    public BakedModel bake(ModelBaker modelBakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform) {
        return new CustomBakedBarrelModel(this.opened.bake(modelBakery, spriteGetter, transform), this.unopened.bake(modelBakery, spriteGetter, transform), this.vanilla == null ? null : this.vanilla.bake(modelBakery, spriteGetter, transform));
    }

    public static class CustomBakedBarrelModel
    implements BakedModel,
    FabricBakedModel {
        private final BakedModel opened;
        private final BakedModel unopened;
        @Nullable
        private final BakedModel vanilla;

        public CustomBakedBarrelModel(BakedModel opened, BakedModel unopened, @Nullable BakedModel vanilla) {
            this.opened = opened;
            this.unopened = unopened;
            this.vanilla = vanilla;
        }

        public boolean isVanillaAdapter() {
            return false;
        }

        public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
            Object data = blockView.getBlockEntityRenderData(pos);
            BakedModel model = this.unopened;
            if (LootrAPI.isVanillaTextures() && this.vanilla != null) {
                model = this.vanilla;
            }
            if (data == Boolean.TRUE) {
                model = this.opened;
            }
            if (model != null) {
                QuadEmitter emitter = context.getEmitter();
                Renderer renderer = RendererAccess.INSTANCE.getRenderer();
                if (renderer != null) {
                    RenderMaterial material = renderer.materialById(RenderMaterial.MATERIAL_STANDARD);
                    for (Direction dir : Direction.values()) {
                        for (BakedQuad quad : model.getQuads(state, dir, randomSupplier.get())) {
                            emitter.fromVanilla(quad, material, dir);
                            emitter.emit();
                        }
                    }
                    for (BakedQuad quad : model.getQuads(state, null, randomSupplier.get())) {
                        emitter.fromVanilla(quad, material, null);
                        emitter.emit();
                    }
                }
            }
        }

        public void emitItemQuads(ItemStack stack, Supplier<RandomSource> randomSupplier, RenderContext context) {
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            if (LootrAPI.isVanillaTextures() && this.vanilla != null) {
                return this.vanilla.getQuads(state, side, rand);
            }
            return this.unopened.getQuads(state, side, rand);
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public boolean isCustomRenderer() {
            return true;
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.unopened.getParticleIcon();
        }

        public ItemTransforms getTransforms() {
            return ItemTransforms.NO_TRANSFORMS;
        }

        public ItemOverrides getOverrides() {
            return ItemOverrides.EMPTY;
        }
    }
}

