/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import noobanidus.mods.lootr.common.api.data.DefaultLootFiller;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import org.jetbrains.annotations.Nullable;

public interface ILootrType {
    public String getName();

    @Nullable
    public Block getReplacementBlock();

    @Nullable
    public EntityType<?> getReplacementEntity();

    default public void callback() {
    }

    default public LootFiller getDefaultFiller() {
        return DefaultLootFiller.getInstance();
    }

    default public boolean canDecay() {
        return true;
    }

    default public boolean canRefresh() {
        return true;
    }

    default public boolean isEntity() {
        return false;
    }

    default public boolean canBeMarkedUnopened() {
        return true;
    }

    default public boolean canDropContentsWhenBroken() {
        return true;
    }

    default public boolean displaysUnopenedParticle() {
        return true;
    }

    @Nullable
    default public Container getContainer(ILootrInfo info, ServerLevel level) {
        BlockEntity be;
        if (this.isEntity() && this.getReplacementEntity() != null) {
            Entity entity = level.getEntity(info.getInfoUUID());
            if (entity instanceof Container) {
                Container container = (Container)entity;
                return container;
            }
        } else if (!this.isEntity() && (be = level.getBlockEntity(info.getInfoPos())) instanceof Container) {
            Container container = (Container)be;
            return container;
        }
        return null;
    }
}

