/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.block.entity.LootrDecoratedPotBlockEntity;
import org.jetbrains.annotations.Nullable;

public class LootrDecoratedPotBlock
extends DecoratedPotBlock {
    private static final VoxelShape BOUNDING_BOX = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);

    public LootrDecoratedPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void attack(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        BlockEntity var7 = level.getBlockEntity(blockPos);
        if (var7 instanceof LootrDecoratedPotBlockEntity) {
            LootrDecoratedPotBlockEntity decoratedPotBlockEntity = (LootrDecoratedPotBlockEntity)var7;
            decoratedPotBlockEntity.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
            if (!level.isClientSide()) {
                decoratedPotBlockEntity.dropContent((ServerPlayer)player);
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        this.spawnDestroyParticles(level, player, blockPos, blockState);
        if (blockState.is(BlockTags.GUARDED_BY_PIGLINS)) {
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
        }
        level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, blockPos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
        return blockState;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockEntity var7 = level.getBlockEntity(blockPos);
        if (var7 instanceof LootrDecoratedPotBlockEntity) {
            LootrDecoratedPotBlockEntity decoratedPotBlockEntity = (LootrDecoratedPotBlockEntity)var7;
            level.playSound(null, blockPos, SoundEvents.DECORATED_POT_INSERT_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
            decoratedPotBlockEntity.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
            if (!level.isClientSide()) {
                decoratedPotBlockEntity.dropContent((ServerPlayer)player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void onProjectileHit(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        ItemStack itemStack;
        BlockEntity var5 = levelReader.getBlockEntity(blockPos);
        if (var5 instanceof LootrDecoratedPotBlockEntity) {
            LootrDecoratedPotBlockEntity decoratedPotBlockEntity = (LootrDecoratedPotBlockEntity)var5;
            itemStack = decoratedPotBlockEntity.getPotAsItem();
        } else {
            itemStack = super.getCloneItemStack(levelReader, blockPos, blockState);
        }
        return itemStack;
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        switch (this.getCollisionState(blockGetter, blockPos, collisionContext).ordinal()) {
            case 0: 
            case 2: {
                return BOUNDING_BOX;
            }
            case 1: 
            case 3: {
                return super.getShape(blockState, blockGetter, blockPos, collisionContext);
            }
        }
        return super.getShape(blockState, blockGetter, blockPos, collisionContext);
    }

    protected VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        switch (this.getCollisionState(blockGetter, blockPos, collisionContext).ordinal()) {
            case 0: 
            case 2: {
                return BOUNDING_BOX;
            }
            case 1: 
            case 3: {
                return super.getShape(blockState, blockGetter, blockPos, collisionContext);
            }
        }
        return super.getShape(blockState, blockGetter, blockPos, collisionContext);
    }

    private CollisionState getCollisionState(BlockGetter getter, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (!(blockEntity instanceof LootrDecoratedPotBlockEntity)) {
            return CollisionState.OTHER;
        }
        LootrDecoratedPotBlockEntity potBlockEntity = (LootrDecoratedPotBlockEntity)blockEntity;
        if (!(context instanceof EntityCollisionContext)) {
            return CollisionState.OTHER;
        }
        EntityCollisionContext entityContext = (EntityCollisionContext)context;
        Entity entity = entityContext.getEntity();
        if (entity == null) {
            return CollisionState.OTHER;
        }
        if (entity instanceof ItemEntity) {
            return CollisionState.ITEM_ENTITY;
        }
        if (!(entity instanceof Player)) {
            return CollisionState.OTHER;
        }
        Player player = (Player)entity;
        if (player.level().isClientSide()) {
            if (potBlockEntity.hasClientOpened(player)) {
                return CollisionState.PLAYER_OPEN;
            }
            return CollisionState.PLAYER_CLOSED;
        }
        if (potBlockEntity.hasVisualOpened(player)) {
            return CollisionState.PLAYER_OPEN;
        }
        return CollisionState.PLAYER_CLOSED;
    }

    protected boolean hasAnalogOutputSignal(BlockState blockState) {
        return super.hasAnalogOutputSignal(blockState);
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        return super.getAnalogOutputSignal(blockState, level, blockPos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new LootrDecoratedPotBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return ILootrBlockEntity::ticker;
    }

    static enum CollisionState {
        PLAYER_OPEN,
        PLAYER_CLOSED,
        ITEM_ENTITY,
        OTHER;

    }
}

