/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.client.block;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BrushableModel
implements UnbakedModel {
    private final UnbakedModel opened;
    private final UnbakedModel stage0;
    private final UnbakedModel stage1;
    private final UnbakedModel stage2;
    private final UnbakedModel stage3;
    private Collection<ResourceLocation> dependencies = null;

    public BrushableModel(UnbakedModel opened, UnbakedModel stage0, UnbakedModel stage1, UnbakedModel stage2, UnbakedModel stage3) {
        this.opened = opened;
        this.stage0 = stage0;
        this.stage1 = stage1;
        this.stage2 = stage2;
        this.stage3 = stage3;
    }

    public Collection<ResourceLocation> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = Streams.concat((Stream[])new Stream[]{this.opened.getDependencies().stream(), this.stage0.getDependencies().stream(), this.stage1.getDependencies().stream(), this.stage2.getDependencies().stream(), this.stage3.getDependencies().stream()}).collect(Collectors.toSet());
        }
        return this.dependencies;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> function) {
        this.opened.resolveParents(function);
        this.stage0.resolveParents(function);
        this.stage1.resolveParents(function);
        this.stage2.resolveParents(function);
        this.stage3.resolveParents(function);
    }

    @Nullable
    public BakedModel bake(ModelBaker modelBakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform) {
        return new BakedBrushableModel(this.opened.bake(modelBakery, spriteGetter, transform), this.stage0.bake(modelBakery, spriteGetter, transform), this.stage1.bake(modelBakery, spriteGetter, transform), this.stage2.bake(modelBakery, spriteGetter, transform), this.stage3.bake(modelBakery, spriteGetter, transform));
    }

    public static class BakedBrushableModel
    implements BakedModel,
    FabricBakedModel {
        private final BakedModel opened;
        private final BakedModel stage0;
        private final BakedModel stage1;
        private final BakedModel stage2;
        private final BakedModel stage3;

        public BakedBrushableModel(BakedModel opened, BakedModel stage0, BakedModel stage1, BakedModel stage2, BakedModel stage3) {
            this.opened = opened;
            this.stage0 = stage0;
            this.stage1 = stage1;
            this.stage2 = stage2;
            this.stage3 = stage3;
        }

        public boolean isVanillaAdapter() {
            return false;
        }

        public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
            BakedModel model;
            Object data = blockView.getBlockEntityRenderData(pos);
            if (data == Boolean.TRUE) {
                model = this.opened;
            } else {
                switch ((Integer)state.getValue((Property)BlockStateProperties.DUSTED)) {
                    case 3: {
                        BakedModel bakedModel = this.stage3;
                        break;
                    }
                    case 2: {
                        BakedModel bakedModel = this.stage2;
                        break;
                    }
                    case 1: {
                        BakedModel bakedModel = this.stage1;
                        break;
                    }
                    default: {
                        BakedModel bakedModel = model = this.stage0;
                    }
                }
            }
            if (model != null) {
                QuadEmitter emitter = context.getEmitter();
                Renderer renderer = RendererAccess.INSTANCE.getRenderer();
                if (renderer != null) {
                    RenderMaterial material = renderer.materialById(RenderMaterial.MATERIAL_STANDARD);
                    for (Direction dir : Direction.values()) {
                        for (BakedQuad quad : model.getQuads(state, dir, randomSupplier.get())) {
                            emitter.fromVanilla(quad, material, dir);
                            emitter.emit();
                        }
                    }
                    for (BakedQuad quad : model.getQuads(state, null, randomSupplier.get())) {
                        emitter.fromVanilla(quad, material, null);
                        emitter.emit();
                    }
                }
            }
        }

        public void emitItemQuads(ItemStack stack, Supplier<RandomSource> randomSupplier, RenderContext context) {
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            return this.stage0.getQuads(state, side, rand);
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public boolean isCustomRenderer() {
            return true;
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.stage0.getParticleIcon();
        }

        public ItemTransforms getTransforms() {
            return ItemTransforms.NO_TRANSFORMS;
        }

        public ItemOverrides getOverrides() {
            return ItemOverrides.EMPTY;
        }
    }
}

