/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.event;

import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.fabric.config.ConfigManager;
import org.jetbrains.annotations.Nullable;

public class HandleBreak {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean beforeBlockBreak(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity) {
        ILootrBlockEntity lbe;
        if (world.isClientSide() || !state.is(LootrTags.Blocks.CONTAINERS)) {
            return true;
        }
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrBlockEntity && !(lbe = iLootrBlockEntity).hasLootTable()) {
            return true;
        }
        if (LootrAPI.isFakePlayer(player) && LootrAPI.isFakePlayerBreakEnabled() || LootrAPI.isBreakEnabled()) {
            return true;
        }
        if (player instanceof FakePlayer && LootrAPI.isFakePlayerBreakEnabled() || LootrAPI.isBreakEnabled()) {
            return true;
        }
        if (LootrAPI.isBreakDisabled()) {
            if (player.getAbilities().instabuild) {
                if (player.isShiftKeyDown()) return true;
                player.displayClientMessage((Component)Component.translatable((String)"lootr.message.cannot_break_sneak").setStyle(HandleBreak.getChatStyle()), false);
                return false;
            }
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.cannot_break").setStyle(HandleBreak.getChatStyle()), false);
            return false;
        }
        if (player.isShiftKeyDown()) return true;
        player.displayClientMessage((Component)Component.translatable((String)"lootr.message.should_sneak").setStyle(HandleBreak.getChatStyle()), false);
        player.displayClientMessage((Component)Component.translatable((String)"lootr.message.should_sneak2").setStyle(HandleBreak.getChatStyle()), false);
        return false;
    }

    public static void afterBlockBreak(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity) {
        if (state.is(LootrTags.Blocks.CONTAINERS)) {
            blockEntity.setChanged();
            ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
            if (iLootrBlockEntity instanceof ILootrBlockEntity) {
                ILootrBlockEntity lbe = iLootrBlockEntity;
                lbe.updatePacketViaForce(blockEntity);
            }
        }
    }

    public static Style getChatStyle() {
        if (ConfigManager.get().notifications.disable_message_styles) {
            return Style.EMPTY;
        }
        return Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.AQUA));
    }
}

