/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.fabric.client.item.LootrChestItemRenderer;

public class LootrChestCartRenderer<T extends LootrChestMinecartEntity>
extends MinecartRenderer<T> {
    public LootrChestCartRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, modelLayerLocation);
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.pushPose();
        long i = (long)pEntity.getId() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        pMatrixStack.translate(f, f1, f2);
        double d0 = Mth.lerp((double)pPartialTicks, (double)((LootrChestMinecartEntity)pEntity).xOld, (double)pEntity.getX());
        double d1 = Mth.lerp((double)pPartialTicks, (double)((LootrChestMinecartEntity)pEntity).yOld, (double)pEntity.getY());
        double d2 = Mth.lerp((double)pPartialTicks, (double)((LootrChestMinecartEntity)pEntity).zOld, (double)pEntity.getZ());
        Vec3 vec3 = pEntity.getPos(d0, d1, d2);
        float f3 = Mth.lerp((float)pPartialTicks, (float)((LootrChestMinecartEntity)pEntity).xRotO, (float)pEntity.getXRot());
        if (vec3 != null) {
            Vec3 vec31 = pEntity.getPosOffs(d0, d1, d2, (double)0.3f);
            Vec3 vec32 = pEntity.getPosOffs(d0, d1, d2, (double)-0.3f);
            if (vec31 == null) {
                vec31 = vec3;
            }
            if (vec32 == null) {
                vec32 = vec3;
            }
            pMatrixStack.translate(vec3.x - d0, (vec31.y + vec32.y) / 2.0 - d1, vec3.z - d2);
            Vec3 vec33 = vec32.add(-vec31.x, -vec31.y, -vec31.z);
            if (vec33.length() != 0.0) {
                vec33 = vec33.normalize();
                pEntityYaw = (float)(Math.atan2(vec33.z, vec33.x) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vec33.y) * 73.0);
            }
        }
        pMatrixStack.translate(0.0, 0.375, 0.0);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - pEntityYaw));
        pMatrixStack.mulPose(Axis.ZP.rotationDegrees(-f3));
        float f5 = (float)pEntity.getHurtTime() - pPartialTicks;
        float f6 = pEntity.getDamage() - pPartialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            pMatrixStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f5) * f5 * f6 / 10.0f * (float)pEntity.getHurtDir()));
        }
        int j = pEntity.getDisplayOffset();
        pMatrixStack.pushPose();
        pMatrixStack.scale(0.75f, 0.75f, 0.75f);
        pMatrixStack.translate(-0.5, (double)((float)(j - 8) / 16.0f), 0.5);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        LootrChestItemRenderer.getInstance().renderByMinecart((LootrChestMinecartEntity)pEntity, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.popPose();
        pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(pEntity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(this.model.renderType(this.getTextureLocation((AbstractMinecart)pEntity)));
        this.model.renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
        pMatrixStack.popPose();
    }
}

