/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.impl;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.LockCode;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import noobanidus.mods.lootr.common.api.DataToCopy;
import noobanidus.mods.lootr.common.api.IPlatformAPI;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinBaseContainerBlockEntity;
import noobanidus.mods.lootr.fabric.network.to_client.PacketCloseCart;
import noobanidus.mods.lootr.fabric.network.to_client.PacketCloseContainer;
import noobanidus.mods.lootr.fabric.network.to_client.PacketOpenCart;
import noobanidus.mods.lootr.fabric.network.to_client.PacketOpenContainer;
import noobanidus.mods.lootr.fabric.network.to_client.PacketPerformBreakEffect;
import noobanidus.mods.lootr.fabric.network.to_client.PacketRefreshSection;

public class PlatformAPIImpl
implements IPlatformAPI {
    @Override
    public void performCartOpen(ILootrCart cart, ServerPlayer player) {
        ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new PacketOpenCart(cart.asEntity().getId()));
    }

    @Override
    public void performCartOpen(ILootrCart cart) {
        Level level = cart.getInfoLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Packet packet = ServerPlayNetworking.createS2CPacket((CustomPacketPayload)new PacketOpenCart(cart.asEntity().getId()));
            serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(cart.asEntity().blockPosition()), false).forEach(player -> player.connection.send(packet));
        }
    }

    @Override
    public void performCartClose(ILootrCart cart, ServerPlayer player) {
        ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new PacketCloseCart(cart.asEntity().getId()));
    }

    @Override
    public void performCartClose(ILootrCart cart) {
        Level level = cart.getInfoLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Packet packet = ServerPlayNetworking.createS2CPacket((CustomPacketPayload)new PacketCloseCart(cart.asEntity().getId()));
            serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(cart.asEntity().blockPosition()), false).forEach(player -> player.connection.send(packet));
        }
    }

    @Override
    public void performBlockOpen(ILootrBlockEntity blockEntity, ServerPlayer player) {
        ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new PacketOpenContainer(blockEntity.asBlockEntity().getBlockPos()));
    }

    @Override
    public void performBlockOpen(ILootrBlockEntity blockEntity) {
        Level level = blockEntity.getInfoLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Packet packet = ServerPlayNetworking.createS2CPacket((CustomPacketPayload)new PacketOpenContainer(blockEntity.asBlockEntity().getBlockPos()));
            serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(blockEntity.asBlockEntity().getBlockPos()), false).forEach(player -> player.connection.send(packet));
        }
    }

    @Override
    public void performBlockClose(ILootrBlockEntity blockEntity, ServerPlayer player) {
        ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new PacketCloseContainer(blockEntity.asBlockEntity().getBlockPos()));
    }

    @Override
    public void performBlockClose(ILootrBlockEntity blockEntity) {
        Level level = blockEntity.getInfoLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Packet packet = ServerPlayNetworking.createS2CPacket((CustomPacketPayload)new PacketCloseContainer(blockEntity.asBlockEntity().getBlockPos()));
            serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(blockEntity.asBlockEntity().getBlockPos()), false).forEach(player -> player.connection.send(packet));
        }
    }

    @Override
    public DataToCopy copySpecificData(BlockEntity oldBlockEntity) {
        LockCode key = LockCode.NO_LOCK;
        if (oldBlockEntity instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity baseContainer = (BaseContainerBlockEntity)oldBlockEntity;
            key = ((AccessorMixinBaseContainerBlockEntity)baseContainer).getLockKey();
        }
        return new DataToCopy(null, key);
    }

    @Override
    public void restoreSpecificData(DataToCopy data, BlockEntity newBlockEntity) {
        if (newBlockEntity instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity baseContainer = (BaseContainerBlockEntity)newBlockEntity;
            ((AccessorMixinBaseContainerBlockEntity)baseContainer).setLockKey(data.lockCode());
        }
    }

    @Override
    public void refreshPlayerSection(ServerPlayer player) {
        ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)PacketRefreshSection.INSTANCE);
    }

    @Override
    public void performPotBreak(ILootrBlockEntity blockEntity, ServerPlayer player) {
        Level level = blockEntity.getInfoLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Packet packet = ServerPlayNetworking.createS2CPacket((CustomPacketPayload)new PacketPerformBreakEffect(player.getId(), blockEntity.asBlockEntity().getBlockPos()));
            serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(blockEntity.asBlockEntity().getBlockPos()), false).forEach(splayer -> splayer.connection.send(packet));
        }
    }
}

