/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import org.jetbrains.annotations.NotNull;

public class SimpleLootrInstance {
    protected final class_2371<class_1799> items;
    protected final Set<UUID> clientOpeners = new ObjectOpenHashSet();
    protected UUID infoId = null;
    protected boolean hasBeenOpened = false;
    protected String cachedId;
    protected boolean clientOpened = false;
    protected boolean savingToItem = false;
    protected boolean providesOwnUuid = false;
    protected final Supplier<Set<UUID>> visualOpenersSupplier;

    public SimpleLootrInstance(Supplier<Set<UUID>> visualOpenersSupplier, int size) {
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        this.visualOpenersSupplier = visualOpenersSupplier;
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public Set<UUID> getClientOpeners() {
        return this.clientOpeners;
    }

    public boolean isClientOpened() {
        return this.clientOpened;
    }

    public void setClientOpened(boolean opened) {
        this.clientOpened = opened;
    }

    @NotNull
    public UUID getInfoUUID() {
        if (this.providesOwnUuid) {
            throw new IllegalStateException("This instance provides its own UUID but hasn't overriden `getInfoUUID`: " + String.valueOf(this));
        }
        if (this.infoId == null) {
            this.infoId = UUID.randomUUID();
        }
        return this.infoId;
    }

    public String getInfoKey() {
        if (this.cachedId == null) {
            this.cachedId = ILootrInfo.generateInfoKey(this.getInfoUUID());
        }
        return this.cachedId;
    }

    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    public int getInfoContainerSize() {
        return this.items.size();
    }

    public void setHasBeenOpened() {
        this.hasBeenOpened = true;
    }

    public boolean isSavingToItem() {
        return this.savingToItem;
    }

    public void setSavingToItem(boolean saving) {
        this.savingToItem = saving;
    }

    public void loadAdditional(class_2487 compound, class_7225.class_7874 provder) {
        if (!this.providesOwnUuid && compound.method_25928("LootrId")) {
            this.infoId = compound.method_25926("LootrId");
        }
        if (compound.method_10573("LootrHasBeenOpened", 1)) {
            this.hasBeenOpened = compound.method_10577("LootrHasBeenOpened");
        }
        if (this.infoId == null && !this.providesOwnUuid) {
            this.getInfoUUID();
        }
        this.clientOpeners.clear();
        if (compound.method_10545("LootrOpeners")) {
            class_2499 list = compound.method_10554("LootrOpeners", 11);
            for (class_2520 thisTag : list) {
                this.clientOpeners.add(class_2512.method_25930((class_2520)thisTag));
            }
        }
    }

    public void saveAdditional(class_2487 compound, class_7225.class_7874 provider, boolean isClientSide) {
        if (!(LootrAPI.shouldDiscard() || this.isSavingToItem() || this.providesOwnUuid)) {
            compound.method_25927("LootrId", this.getInfoUUID());
        }
        compound.method_10556("LootrHasBeenOpened", this.hasBeenOpened);
        if (isClientSide && !this.clientOpeners.isEmpty()) {
            class_2499 list = new class_2499();
            for (UUID opener : this.clientOpeners) {
                list.add((Object)class_2512.method_25929((UUID)opener));
            }
            compound.method_10566("LootrOpeners", (class_2520)list);
        }
    }

    public void fillUpdateTag(class_2487 result, class_7225.class_7874 provider, boolean isClientSide) {
        this.saveAdditional(result, provider, isClientSide);
        if (!isClientSide) {
            Set<UUID> currentOpeners = this.visualOpenersSupplier.get();
            if (currentOpeners != null) {
                class_2499 list = new class_2499();
                for (UUID opener : Sets.intersection(currentOpeners, LootrAPI.getPlayerIds())) {
                    list.add((Object)class_2512.method_25929((UUID)opener));
                }
                if (!list.isEmpty()) {
                    result.method_10566("LootrOpeners", (class_2520)list);
                }
            }
        } else {
            LootrAPI.LOG.error("Tried to fillUpdateTag on the client side for SimpleLootrInstance: {}", (Object)this);
        }
    }
}

