/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import noobanidus.mods.lootr.common.api.ILootrAPI;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.adapter.AdapterMap;
import noobanidus.mods.lootr.common.api.adapter.ILootrDataAdapter;
import noobanidus.mods.lootr.common.api.client.ILootrFabricModelProvider;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.filter.ILootrFilter;
import noobanidus.mods.lootr.common.api.filter.ILootrFilterProvider;
import noobanidus.mods.lootr.common.api.processor.ILootrBlockEntityProcessor;
import noobanidus.mods.lootr.common.api.processor.ILootrEntityProcessor;
import noobanidus.mods.lootr.common.api.replacement.BlockReplacementMap;
import noobanidus.mods.lootr.common.api.replacement.ILootrBlockReplacementProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class LootrServiceRegistry {
    private static LootrServiceRegistry INSTANCE;
    private final Map<class_2591<?>, Function<?, ?>> blockEntityConverterMap = new Object2ObjectOpenHashMap();
    private final Map<class_1299<?>, Function<?, ?>> entityConverterMap = new Object2ObjectOpenHashMap();
    private final List<ILootrFilter> filters = new ObjectArrayList();
    private final List<ILootrBlockEntityProcessor.Post> blockEntityPostProcessors = new ObjectArrayList();
    private final List<ILootrBlockEntityProcessor.Pre> blockEntityPreProcessors = new ObjectArrayList();
    private final List<ILootrEntityProcessor.Pre> entityPreProcessors = new ObjectArrayList();
    private final List<ILootrEntityProcessor.Post> entityPostProcessors = new ObjectArrayList();
    private final AdapterMap adapterMap = new AdapterMap();
    private final BlockReplacementMap replacementMap = new BlockReplacementMap();
    private final Map<String, ILootrType> typeMap = new Object2ObjectOpenHashMap();
    private final List<ILootrFabricModelProvider> fabricModelProviders = new ObjectArrayList();

    public LootrServiceRegistry() {
        ClassLoader classLoader = ILootrAPI.class.getClassLoader();
        ServiceLoader<ILootrBlockEntityConverter> loader = ServiceLoader.load(ILootrBlockEntityConverter.class, classLoader);
        for (ILootrBlockEntityConverter iLootrBlockEntityConverter : loader) {
            this.blockEntityConverterMap.put(iLootrBlockEntityConverter.getBlockEntityType(), iLootrBlockEntityConverter);
        }
        ServiceLoader<ILootrEntityConverter> loader2 = ServiceLoader.load(ILootrEntityConverter.class, classLoader);
        for (ILootrEntityConverter iLootrEntityConverter : loader2) {
            this.entityConverterMap.put(iLootrEntityConverter.getEntityType(), iLootrEntityConverter);
        }
        ServiceLoader<ILootrFilterProvider> serviceLoader = ServiceLoader.load(ILootrFilterProvider.class, classLoader);
        for (ILootrFilterProvider iLootrFilterProvider : serviceLoader) {
            this.filters.addAll(iLootrFilterProvider.getFilters());
        }
        this.filters.sort(Comparator.comparingInt(ILootrFilter::getPriority).reversed());
        ServiceLoader<ILootrBlockEntityProcessor.Post> serviceLoader2 = ServiceLoader.load(ILootrBlockEntityProcessor.Post.class, classLoader);
        for (ILootrBlockEntityProcessor.Post post : serviceLoader2) {
            this.blockEntityPostProcessors.add(post);
        }
        ServiceLoader<ILootrBlockEntityProcessor.Pre> serviceLoader3 = ServiceLoader.load(ILootrBlockEntityProcessor.Pre.class, classLoader);
        for (ILootrBlockEntityProcessor.Pre pre : serviceLoader3) {
            this.blockEntityPreProcessors.add(pre);
        }
        ServiceLoader<ILootrEntityProcessor.Pre> serviceLoader4 = ServiceLoader.load(ILootrEntityProcessor.Pre.class, classLoader);
        for (ILootrEntityProcessor.Pre pre : serviceLoader4) {
            this.entityPreProcessors.add(pre);
        }
        ServiceLoader<ILootrEntityProcessor.Post> serviceLoader5 = ServiceLoader.load(ILootrEntityProcessor.Post.class, classLoader);
        for (ILootrEntityProcessor.Post post : serviceLoader5) {
            this.entityPostProcessors.add(post);
        }
        ServiceLoader<ILootrDataAdapter> serviceLoader6 = ServiceLoader.load(ILootrDataAdapter.class, classLoader);
        for (ILootrDataAdapter iLootrDataAdapter : serviceLoader6) {
            this.adapterMap.register(iLootrDataAdapter);
        }
        ServiceLoader<ILootrBlockReplacementProvider> serviceLoader7 = ServiceLoader.load(ILootrBlockReplacementProvider.class, classLoader);
        for (ILootrBlockReplacementProvider iLootrBlockReplacementProvider : serviceLoader7) {
            this.replacementMap.register(iLootrBlockReplacementProvider);
        }
        this.replacementMap.sort();
        ServiceLoader<ILootrType> serviceLoader8 = ServiceLoader.load(ILootrType.class, classLoader);
        for (ILootrType type : serviceLoader8) {
            this.typeMap.put(type.getName(), type);
            type.callback();
        }
        ServiceLoader<ILootrFabricModelProvider> serviceLoader9 = ServiceLoader.load(ILootrFabricModelProvider.class, classLoader);
        for (ILootrFabricModelProvider appender : serviceLoader9) {
            this.fabricModelProviders.add(appender);
        }
    }

    public static LootrServiceRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LootrServiceRegistry();
        }
        return INSTANCE;
    }

    @Nullable
    private static <T> Function<T, ILootrBlockEntity> getBlockEntity(class_2591<?> clazz) {
        return LootrServiceRegistry.getInstance().blockEntityConverterMap.get(clazz);
    }

    @Nullable
    private static <T> Function<T, ILootrCart> getEntity(class_1299<?> clazz) {
        return LootrServiceRegistry.getInstance().entityConverterMap.get(clazz);
    }

    @Nullable
    static <T extends class_2586> ILootrBlockEntity convertBlockEntity(T blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        Function<T, ILootrBlockEntity> converter = LootrServiceRegistry.getBlockEntity(blockEntity.method_11017());
        if (converter == null) {
            return null;
        }
        return converter.apply(blockEntity);
    }

    @Nullable
    static <T extends class_1297> ILootrCart convertEntity(T entity) {
        if (entity == null) {
            return null;
        }
        Function<T, ILootrCart> converter = LootrServiceRegistry.getEntity(entity.method_5864());
        if (converter == null) {
            return null;
        }
        return converter.apply(entity);
    }

    static List<ILootrFilter> getFilters() {
        return LootrServiceRegistry.getInstance().filters;
    }

    static List<ILootrEntityProcessor.Pre> getEntityPreProcessors() {
        return LootrServiceRegistry.getInstance().entityPreProcessors;
    }

    static List<ILootrBlockEntityProcessor.Pre> getBlockEntityPreProcessors() {
        return LootrServiceRegistry.getInstance().blockEntityPreProcessors;
    }

    static List<ILootrEntityProcessor.Post> getEntityPostProcessors() {
        return LootrServiceRegistry.getInstance().entityPostProcessors;
    }

    static List<ILootrBlockEntityProcessor.Post> getBlockEntityPostProcessors() {
        return LootrServiceRegistry.getInstance().blockEntityPostProcessors;
    }

    static class_2680 getReplacementBlockState(class_2680 block) {
        return LootrServiceRegistry.getInstance().replacementMap.getReplacement(block);
    }

    public static void clearReplacements() {
        LootrServiceRegistry.getInstance().replacementMap.clear();
    }

    @Nullable
    static <T> ILootrDataAdapter<T> getAdapter(T type) {
        return LootrServiceRegistry.getInstance().adapterMap.getAdapter(type);
    }

    @Nullable
    static ILootrType getType(String type) {
        return LootrServiceRegistry.getInstance().typeMap.get(type);
    }

    @ApiStatus.Internal
    public static List<ILootrFabricModelProvider> getModelAppenders() {
        return LootrServiceRegistry.getInstance().fabricModelProviders;
    }
}

