/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface ILootrInfo {
    public LootrBlockType getInfoBlockType();

    public LootrInfoType getInfoType();

    @NotNull
    default public class_243 getInfoVec() {
        return class_243.method_24953((class_2382)this.getInfoPos());
    }

    @NotNull
    public UUID getInfoUUID();

    public String getInfoKey();

    public static String generateInfoKey(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public boolean hasBeenOpened();

    public boolean isPhysicallyOpen();

    @NotNull
    public class_2338 getInfoPos();

    @Nullable
    public class_2561 getInfoDisplayName();

    @NotNull
    public class_5321<class_1937> getInfoDimension();

    public int getInfoContainerSize();

    @Nullable
    public class_2371<class_1799> getInfoReferenceInventory();

    public boolean isInfoReferenceInventory();

    @Nullable
    public class_5321<class_52> getInfoLootTable();

    public long getInfoLootSeed();

    @Nullable
    default public class_1937 getInfoLevel() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            return null;
        }
        return server.method_3847(this.getInfoDimension());
    }

    @Nullable
    default public class_1263 getInfoContainer() {
        class_2586 be;
        class_3218 level;
        class_1937 class_19372 = this.getInfoLevel();
        if (!(class_19372 instanceof class_3218) || (level = (class_3218)class_19372).method_8608()) {
            return null;
        }
        if (this.getInfoType() == LootrInfoType.CONTAINER_ENTITY) {
            class_1297 entity = level.method_14190(this.getInfoUUID());
            if (entity instanceof class_1263) {
                class_1263 container = (class_1263)entity;
                return container;
            }
        } else if (this.getInfoType() == LootrInfoType.CONTAINER_BLOCK_ENTITY && (be = level.method_8321(this.getInfoPos())) instanceof class_1263) {
            class_1263 container = (class_1263)be;
            return container;
        }
        return null;
    }

    default public class_2371<class_1799> buildInitialInventory() {
        return class_2371.method_10213((int)this.getInfoContainerSize(), (Object)class_1799.field_8037);
    }

    default public void saveInfoToTag(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10569("type", this.getInfoType().ordinal());
        tag.method_10569("blockType", this.getInfoBlockType().ordinal());
        tag.method_10566("position", class_2512.method_10692((class_2338)this.getInfoPos()));
        tag.method_10582("key", this.getInfoKey());
        tag.method_10582("dimension", this.getInfoDimension().method_29177().toString());
        tag.method_25927("uuid", this.getInfoUUID());
        tag.method_10569("size", this.getInfoContainerSize());
        if (this.getInfoLootTable() != null) {
            tag.method_10582("table", this.getInfoLootTable().method_29177().toString());
            tag.method_10544("seed", this.getInfoLootSeed());
        }
        if (this.getInfoDisplayName() != null) {
            tag.method_10582("name", class_2561.class_2562.method_10867((class_2561)this.getInfoDisplayName(), (class_7225.class_7874)provider));
        }
        if (this.isInfoReferenceInventory()) {
            tag.method_10569("referenceSize", this.getInfoReferenceInventory().size());
            tag.method_10566("reference", (class_2520)class_1262.method_5427((class_2487)new class_2487(), this.getInfoReferenceInventory(), (boolean)true, (class_7225.class_7874)provider));
        }
    }

    public static ILootrInfo loadInfoFromTag(class_2487 tag, class_7225.class_7874 provider) {
        LootrInfoType infoType = LootrInfoType.CONTAINER_BLOCK_ENTITY;
        if (tag.method_10573("type", 3)) {
            infoType = LootrInfoType.values()[tag.method_10550("type")];
        } else if (tag.method_10545("entity") && tag.method_10577("entity")) {
            infoType = LootrInfoType.CONTAINER_ENTITY;
        } else {
            LootrAPI.LOG.error("Couldn't deduce the infoType of LootrInfo from tag: {}", (Object)tag);
        }
        LootrBlockType blockType = null;
        if (tag.method_10573("blockType", 3)) {
            blockType = LootrBlockType.values()[tag.method_10550("blockType")];
        }
        class_2338 pos = class_2512.method_10691((class_2487)tag, (String)"position").orElse(class_2338.field_10980);
        UUID uuid = tag.method_25926("uuid");
        class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)tag.method_10558("dimension")));
        int size = tag.method_10550("size");
        class_5250 name = null;
        if (tag.method_10545("name")) {
            name = class_2561.class_2562.method_10877((String)tag.method_10558("name"), (class_7225.class_7874)provider);
        }
        class_2371 reference = null;
        if (tag.method_10545("reference") && tag.method_10545("referenceSize")) {
            reference = class_2371.method_10213((int)tag.method_10550("referenceSize"), (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)tag.method_10562("reference"), (class_2371)reference, (class_7225.class_7874)provider);
            blockType = LootrBlockType.INVENTORY;
        }
        if (blockType == null) {
            blockType = infoType == LootrInfoType.CONTAINER_ENTITY ? LootrBlockType.ENTITY : LootrBlockType.CHEST;
        }
        class_5321 table = null;
        long seed = -1L;
        if (tag.method_10545("table")) {
            table = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)tag.method_10558("table")));
            seed = tag.method_10537("seed");
        }
        return new BaseLootrInfo(blockType, infoType, uuid, ILootrInfo.generateInfoKey(uuid), pos, (class_2561)name, (class_5321<class_1937>)dimension, size, (class_2371<class_1799>)reference, (class_5321<class_52>)table, seed);
    }

    public static enum LootrInfoType {
        CONTAINER_BLOCK_ENTITY,
        CONTAINER_ENTITY;

    }
}

