/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3908;
import net.minecraft.class_4838;
import net.minecraft.class_6862;
import net.minecraft.class_7151;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.ILootrAPI;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.MenuBuilder;
import noobanidus.mods.lootr.common.api.data.DefaultLootFiller;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.filter.ILootrFilter;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.client.ClientHooks;
import noobanidus.mods.lootr.common.config.Replacements;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.impl.LootrServiceRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultLootrAPIImpl
implements ILootrAPI {
    private static final class_3341 DESERT_PYRAMID_ADDITIONAL = new class_3341(-5, -30, -5, 5, 4, 4);

    @Override
    public final void handleProviderSneak(@Nullable ILootrInfoProvider provider, class_3222 player) {
        if (provider == null) {
            return;
        }
        if (provider.removeVisualOpener((class_1657)player)) {
            provider.performClose(player);
            provider.performUpdate(player);
        }
    }

    @Override
    public final void handleProviderOpen(@Nullable ILootrInfoProvider provider, class_3222 player) {
        int refreshValue;
        class_2624 baseContainer;
        if (provider == null) {
            return;
        }
        if (player.method_7325()) {
            player.method_17355(null);
            return;
        }
        if (provider.getInfoLevel() == null || provider.getInfoLevel().method_8608()) {
            return;
        }
        if (provider.getInfoUUID() == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.invalid_block").method_10862(LootrAPI.getInvalidStyle()), true);
            return;
        }
        if (provider instanceof class_2624 && !(baseContainer = (class_2624)provider).method_17489((class_1657)player)) {
            return;
        }
        if (LootrAPI.isDecayed(provider)) {
            provider.performDecay();
            player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.decayed").method_10862(LootrAPI.getDecayStyle()), true);
            LootrAPI.removeDecayed(provider);
            return;
        }
        int decayValue = LootrAPI.getRemainingDecayValue(provider);
        if (decayValue > 0 && LootrAPI.shouldNotify(decayValue)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).method_10862(LootrAPI.getDecayStyle()), true);
        } else if (decayValue == -1 && LootrAPI.isDecaying(provider)) {
            LootrAPI.setDecaying(provider);
            player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.decay_start", (Object[])new Object[]{LootrAPI.getDecayValue() / 20}).method_10862(LootrAPI.getDecayStyle()), true);
        }
        provider.performTrigger(player);
        boolean shouldUpdate = false;
        if (LootrAPI.isRefreshed(provider)) {
            provider.performRefresh();
            provider.performClose();
            LootrAPI.removeRefreshed(provider);
            player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.refreshed").method_10862(LootrAPI.getRefreshStyle()), true);
            shouldUpdate = true;
        }
        if ((refreshValue = LootrAPI.getRemainingRefreshValue(provider)) > 0 && LootrAPI.shouldNotify(refreshValue)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).method_10862(LootrAPI.getRefreshStyle()), true);
        } else if (refreshValue == -1 && LootrAPI.isRefreshing(provider)) {
            LootrAPI.setRefreshing(provider);
            player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_start", (Object[])new Object[]{LootrAPI.getRefreshValue() / 20}).method_10862(LootrAPI.getRefreshStyle()), true);
        }
        ILootrInventory menuProvider = LootrAPI.getInventory(provider, player, DefaultLootFiller.getInstance());
        if (menuProvider == null) {
            return;
        }
        if (!provider.hasOpened((class_1657)player)) {
            player.method_7259(LootrRegistry.getLootedStat());
            LootrRegistry.getStatTrigger().trigger(player);
        }
        if (provider.addOpener((class_1657)player)) {
            provider.performOpen(player);
            shouldUpdate = true;
        }
        if (shouldUpdate) {
            provider.performUpdate(player);
        }
        player.method_17355((class_3908)menuProvider);
        class_4838.method_24733((class_1657)player, (boolean)true);
    }

    @Override
    public final void handleProviderTick(@Nullable ILootrInfoProvider provider) {
        int refreshValue;
        int decayValue;
        if (provider == null) {
            return;
        }
        if (provider.getInfoUUID() == null) {
            return;
        }
        if (provider.getInfoLevel() == null || provider.getInfoLevel().method_8608()) {
            return;
        }
        if (LootrAPI.shouldPerformDecayWhileTicking() && LootrAPI.isDecayed(provider) && provider.hasBeenOpened()) {
            provider.performDecay();
            LootrAPI.removeDecayed(provider);
            return;
        }
        if (LootrAPI.shouldStartDecayWhileTicking() && !LootrAPI.isDecayed(provider) && provider.hasBeenOpened() && (decayValue = LootrAPI.getRemainingDecayValue(provider)) == -1 && LootrAPI.isDecaying(provider)) {
            LootrAPI.setDecaying(provider);
        }
        if (LootrAPI.shouldPerformRefreshWhileTicking() && LootrAPI.isRefreshed(provider) && provider.hasBeenOpened()) {
            provider.performRefresh();
            provider.performClose();
            LootrAPI.removeRefreshed(provider);
            provider.performUpdate();
        }
        if (LootrAPI.shouldStartRefreshWhileTicking() && !LootrAPI.isRefreshed(provider) && provider.hasBeenOpened() && (refreshValue = LootrAPI.getRemainingRefreshValue(provider)) == -1 && LootrAPI.isRefreshing(provider)) {
            LootrAPI.setRefreshing(provider);
        }
    }

    @Override
    public final Set<UUID> getPlayerIds() {
        MinecraftServer server = this.getServer();
        if (server == null) {
            return Set.of();
        }
        HashSet<UUID> result = new HashSet<UUID>();
        for (class_3222 player : server.method_3760().method_14571()) {
            UUID thisUuid;
            if (this.isFakePlayer((class_1657)player) || (thisUuid = player.method_5667()) == null) continue;
            result.add(thisUuid);
        }
        return result;
    }

    @Override
    public final boolean clearPlayerLoot(UUID id) {
        return DataStorage.clearInventories(id);
    }

    @Override
    public final ILootrInventory getInventory(ILootrInfoProvider provider, class_3222 player, LootFiller filler) {
        return DataStorage.getInventory(provider, player, filler);
    }

    @Override
    public final ILootrInventory getInventory(ILootrInfoProvider provider, class_3222 player, LootFiller filler, MenuBuilder menuBuilder) {
        ILootrInventory inventory = DataStorage.getInventory(provider, player, filler);
        if (inventory != null) {
            inventory.setMenuBuilder(menuBuilder);
        }
        return inventory;
    }

    @Override
    @Nullable
    public final ILootrSavedData getData(ILootrInfoProvider provider) {
        return DataStorage.getData(provider);
    }

    @Override
    public final boolean shouldDiscard() {
        return LootrAPI.shouldDiscardIdAndOpeners;
    }

    @Override
    public final boolean isAwarded(UUID uuid, class_3222 player) {
        return DataStorage.isAwarded(uuid, player);
    }

    @Override
    @Deprecated
    public final void award(UUID id, class_3222 player) {
        DataStorage.award(id, player);
    }

    @Override
    public final int getRemainingDecayValue(ILootrInfoProvider provider) {
        return DataStorage.getDecayValue(provider);
    }

    @Override
    public final boolean isDecayed(ILootrInfoProvider provider) {
        return DataStorage.isDecayed(provider);
    }

    @Override
    public final void setDecaying(ILootrInfoProvider provider) {
        DataStorage.setDecaying(provider);
    }

    @Override
    public final void removeDecayed(ILootrInfoProvider provider) {
        DataStorage.removeDecayed(provider);
    }

    @Override
    public final int getRemainingRefreshValue(ILootrInfoProvider provider) {
        return DataStorage.getRefreshValue(provider);
    }

    @Override
    public final boolean isRefreshed(ILootrInfoProvider provider) {
        return DataStorage.isRefreshed(provider);
    }

    @Override
    public final void setRefreshing(ILootrInfoProvider provider) {
        DataStorage.setRefreshing(provider);
    }

    @Override
    public final void removeRefreshed(ILootrInfoProvider provider) {
        DataStorage.removeRefreshed(provider);
    }

    @Override
    @Nullable
    public final <T extends class_2586> ILootrBlockEntity resolveBlockEntity(T blockEntity) {
        return LootrServiceRegistry.convertBlockEntity(blockEntity);
    }

    @Override
    public final <T extends class_1297> ILootrCart resolveEntity(T entity) {
        return LootrServiceRegistry.convertEntity(entity);
    }

    @Override
    public boolean isTaggedStructurePresent(class_3218 level, class_1923 chunkPos, class_6862<class_3195> tag, class_2338 pos) {
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
        List starts = level.method_27056().method_41035(chunkPos, o -> registry.method_40265(registry.method_10206(o)).map(b -> b.method_40220(tag)).orElse(false));
        for (class_3449 start : starts) {
            class_2338 center;
            class_3341 extended = start.method_14969().method_35410(8);
            if (extended.method_14662((class_2382)pos)) {
                return true;
            }
            if (!start.method_16656().method_41618().equals((Object)class_7151.field_37753) || !DESERT_PYRAMID_ADDITIONAL.method_19311((center = start.method_14969().method_22874()).method_10263(), center.method_10264(), center.method_10260()).method_14662((class_2382)pos)) continue;
            return true;
        }
        if (LootrAPI.performPiecewiseCheck()) {
            for (class_3449 start : starts) {
                for (class_3443 piece : start.method_14963()) {
                    if (!piece.method_14935().method_35410(8).method_14662((class_2382)pos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isWorldBorderSafe(class_1937 level, class_2338 pos) {
        if (!this.shouldCheckWorldBorder()) {
            return true;
        }
        return level.method_8621().method_11952(pos);
    }

    @Override
    public boolean isWorldBorderSafe(class_1937 level, class_1923 pos) {
        if (!this.shouldCheckWorldBorder()) {
            return true;
        }
        return level.method_8621().method_11951(pos);
    }

    @Override
    public void playerDestroyed(class_1937 level, class_1657 player, class_2338 pos, @Nullable class_2586 blockEntity) {
        if (!this.shouldDropPlayerLoot() || level.method_8608() || blockEntity == null) {
            return;
        }
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            class_3222 serverPlayer;
            ILootrInventory inventory;
            ILootrBlockEntity provider = iLootrBlockEntity;
            if (player instanceof class_3222 && (inventory = this.getInventory(provider, serverPlayer = (class_3222)player, DefaultLootFiller.getInstance())) != null) {
                class_1264.method_5451((class_1937)level, (class_2338)pos, (class_1263)inventory);
            }
        }
    }

    @Override
    public void refreshSections() {
        MinecraftServer server = this.getServer();
        if (server == null || server.method_3724() || !server.method_3816()) {
            ClientHooks.refreshSection();
        }
    }

    @Override
    @Nullable
    public class_2680 replacementBlockState(class_2680 original) {
        return Replacements.replacement(original);
    }

    @Override
    public List<ILootrFilter> getFilters() {
        return LootrServiceRegistry.getFilters();
    }
}

