/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import noobanidus.mods.lootr.common.api.LootrAPI;
import org.jspecify.annotations.NonNull;

public abstract class UnbakedCustomModel
implements BlockStateModel.Unbaked {
    protected final Identifier opened;
    protected final Identifier unopened;
    protected final Identifier vanilla;
    protected final Variant.SimpleModelState state;
    protected final boolean open;

    public static <T extends UnbakedCustomModel> MapCodec<T> getCodec(Provider<T> provider) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Identifier.CODEC.fieldOf("opened").forGetter(UnbakedCustomModel::getOpened), (App)Identifier.CODEC.fieldOf("unopened").forGetter(UnbakedCustomModel::getUnopened), (App)Identifier.CODEC.fieldOf("vanilla").forGetter(UnbakedCustomModel::getVanilla), (App)Variant.SimpleModelState.MAP_CODEC.fieldOf("state").forGetter(UnbakedCustomModel::getState), (App)Codec.BOOL.fieldOf("open").forGetter(UnbakedCustomModel::getOpen)).apply((Applicative)instance, provider::create));
    }

    public UnbakedCustomModel(Identifier opened, Identifier unopened, Identifier vanilla, Variant.SimpleModelState state, boolean open) {
        this.opened = opened;
        this.unopened = unopened;
        this.vanilla = vanilla;
        this.state = state;
        this.open = open;
    }

    public Identifier getOpened() {
        return this.opened;
    }

    public Identifier getUnopened() {
        return this.unopened;
    }

    public Identifier getVanilla() {
        return this.vanilla;
    }

    public boolean getOpen() {
        return this.open;
    }

    public Variant.SimpleModelState getState() {
        return this.state;
    }

    protected abstract Baker getBaker();

    public BlockStateModel bake(ModelBaker baker) {
        return this.getBaker().bake((BlockStateModel)new SingleVariant(SimpleModelWrapper.bake((ModelBaker)baker, (Identifier)this.opened, (ModelState)this.state.asModelState())), (BlockStateModel)new SingleVariant(SimpleModelWrapper.bake((ModelBaker)baker, (Identifier)this.unopened, (ModelState)this.state.asModelState())), (BlockStateModel)new SingleVariant(SimpleModelWrapper.bake((ModelBaker)baker, (Identifier)this.vanilla, (ModelState)this.state.asModelState())), this.open);
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        resolver.markDependency(this.opened);
        resolver.markDependency(this.unopened);
        resolver.markDependency(this.vanilla);
    }

    @FunctionalInterface
    public static interface Provider<T extends UnbakedCustomModel> {
        public T create(Identifier var1, Identifier var2, Identifier var3, Variant.SimpleModelState var4, boolean var5);
    }

    @FunctionalInterface
    public static interface Baker {
        public BlockStateModel bake(BlockStateModel var1, BlockStateModel var2, BlockStateModel var3, boolean var4);
    }

    public static abstract class Baked
    implements BlockStateModel {
        protected final BlockStateModel unopened;
        protected final BlockStateModel opened;
        protected final BlockStateModel vanilla;
        protected final boolean open;

        public Baked(BlockStateModel opened, BlockStateModel unopened, BlockStateModel vanilla, boolean open) {
            this.unopened = unopened;
            this.opened = opened;
            this.vanilla = vanilla;
            this.open = open;
        }

        public void collectParts(@NonNull RandomSource random, @NonNull List<BlockModelPart> output) {
            if (LootrAPI.isVanillaTextures()) {
                this.vanilla.collectParts(random, output);
            } else if (this.open) {
                this.opened.collectParts(random, output);
            } else {
                this.unopened.collectParts(random, output);
            }
        }

        public TextureAtlasSprite particleIcon() {
            if (LootrAPI.isVanillaTextures()) {
                return this.vanilla.particleIcon();
            }
            return this.unopened.particleIcon();
        }

        protected abstract boolean isOpenFromBATG(BlockAndTintGetter var1, BlockPos var2, BlockState var3, RandomSource var4);

        public Object internalCreateObjectKey(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
            boolean visuallyOpen = this.isOpenFromBATG(level, pos, state, random);
            int facing = ((Direction)state.getValue((Property)BarrelBlock.FACING)).ordinal();
            boolean vanilla = LootrAPI.isVanillaTextures();
            return new BarrelKey(vanilla, this.open, visuallyOpen, facing);
        }
    }

    public record BarrelKey(boolean vanilla, boolean open, boolean visuallyOpen, int facing) {
    }
}

