/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrConstants;
import noobanidus.mods.lootr.common.api.PotDecorationsAdapter;
import noobanidus.mods.lootr.common.block.entity.LootrDecoratedPotBlockEntity;
import noobanidus.mods.lootr.common.client.ClientHooks;
import noobanidus.mods.lootr.common.client.state.LootrDecoratedPotBlockRenderState;
import noobanidus.mods.lootr.common.integration.sherdsapi.SherdsIntegration;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class LootrDecoratedPotRenderer
implements BlockEntityRenderer<LootrDecoratedPotBlockEntity, LootrDecoratedPotBlockRenderState> {
    public static final Identifier DECORATED_POT_SHEET = Identifier.withDefaultNamespace((String)"textures/atlas/decorated_pot.png");
    private static final Material DECORATED_POT = new Material(DECORATED_POT_SHEET, LootrAPI.rl("entity/loot_pot"));
    private static final Material DECORATED_POT_OPENED = new Material(DECORATED_POT_SHEET, LootrAPI.rl("entity/loot_pot_open"));
    public static final ModelLayerLocation OPEN_POT_LAYER = new ModelLayerLocation(LootrConstants.DECORATED_POT, "main");
    private final MaterialSet materials;
    private final ModelPart neck;
    private final ModelPart frontSide;
    private final ModelPart backSide;
    private final ModelPart leftSide;
    private final ModelPart rightSide;
    private final ModelPart top;
    private final ModelPart bottom;
    private final ModelPart open;
    private final ModelPart sherds;
    private static final Map<Identifier, Material> cachedMaterials = new HashMap<Identifier, Material>();

    public LootrDecoratedPotRenderer(BlockEntityRendererProvider.Context context) {
        this(context.entityModelSet(), context.materials());
    }

    public LootrDecoratedPotRenderer(SpecialModelRenderer.BakingContext context) {
        this(context.entityModelSet(), context.materials());
    }

    public LootrDecoratedPotRenderer(EntityModelSet context, MaterialSet materials) {
        this.materials = materials;
        ModelPart modelPart = context.bakeLayer(ModelLayers.DECORATED_POT_BASE);
        this.neck = modelPart.getChild("neck");
        this.top = modelPart.getChild("top");
        this.bottom = modelPart.getChild("bottom");
        ModelPart modelPart2 = context.bakeLayer(ModelLayers.DECORATED_POT_SIDES);
        this.frontSide = modelPart2.getChild("front");
        this.backSide = modelPart2.getChild("back");
        this.leftSide = modelPart2.getChild("left");
        this.rightSide = modelPart2.getChild("right");
        ModelPart modelPart3 = context.bakeLayer(OPEN_POT_LAYER);
        this.open = modelPart3.getChild("open");
        this.sherds = modelPart3.getChild("sherds");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition sherds = partdefinition.addOrReplaceChild("sherds", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        sherds.addOrReplaceChild("angled_sherd1_r1", CubeListBuilder.create().texOffs(17, 21).addBox(-0.5f, -0.5f, -4.5f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-3.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.829f));
        sherds.addOrReplaceChild("sherd2_r1", CubeListBuilder.create().texOffs(14, 19).addBox(-4.5f, -0.5f, -4.5f, 9.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.5f, (float)0.5f, (float)0.0f, (float)0.1309f, (float)0.0f));
        sherds.addOrReplaceChild("sherd1_r1", CubeListBuilder.create().texOffs(4, 16).addBox(-4.5f, -0.5f, -3.5f, 10.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.5f, (float)-1.5f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        partdefinition.addOrReplaceChild("open", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -0.5f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 5).addBox(-2.8257f, 2.4924f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.75f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)-0.0873f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static Material getSideMaterial(ItemStack item) {
        if (!item.isEmpty()) {
            Identifier customSide = SherdsIntegration.getCustomSideTexture(item);
            if (customSide != null) {
                return cachedMaterials.computeIfAbsent(customSide, rl -> new Material(DECORATED_POT_SHEET, rl.withPrefix("entity/decorated_pot/")));
            }
            Material material = Sheets.getDecoratedPotMaterial((ResourceKey)DecoratedPotPatterns.getPatternFromItem((Item)item.getItem()));
            if (material != null) {
                return material;
            }
        }
        return Sheets.DECORATED_POT_SIDE;
    }

    public LootrDecoratedPotBlockRenderState createRenderState() {
        return new LootrDecoratedPotBlockRenderState();
    }

    public void extractRenderState(LootrDecoratedPotBlockEntity blockEntity, LootrDecoratedPotBlockRenderState renderState, float partialTick, Vec3 cameraPosition, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.decorations = null;
        renderState.potDecorations = blockEntity.getDecorations();
        renderState.direction = blockEntity.getDirection();
        DecoratedPotBlockEntity.WobbleStyle decoratedpotblockentity$wobblestyle = blockEntity.lastWobbleStyle;
        renderState.wobbleProgress = decoratedpotblockentity$wobblestyle != null && blockEntity.getLevel() != null ? ((float)(blockEntity.getLevel().getGameTime() - blockEntity.wobbleStartedAtTick) + partialTick) / (float)decoratedpotblockentity$wobblestyle.duration : 0.0f;
        Player player = ClientHooks.getPlayer();
        renderState.visuallyOpen = player != null && blockEntity.hasClientOpened(player);
    }

    public void submit(LootrDecoratedPotBlockRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        Direction direction = renderState.direction;
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - direction.toYRot()));
        if (!renderState.visuallyOpen) {
            poseStack.translate(-0.5, 0.0, -0.5);
            if (renderState.wobbleProgress >= 0.0f && renderState.wobbleProgress <= 1.0f) {
                if (renderState.wobbleStyle == DecoratedPotBlockEntity.WobbleStyle.POSITIVE) {
                    float f1 = renderState.wobbleProgress * ((float)Math.PI * 2);
                    float f2 = -1.5f * (Mth.cos((double)f1) + 0.5f) * Mth.sin((double)(f1 / 2.0f));
                    poseStack.rotateAround((Quaternionfc)Axis.XP.rotation(f2 * 0.015625f), 0.5f, 0.0f, 0.5f);
                    float f3 = Mth.sin((double)f1);
                    poseStack.rotateAround((Quaternionfc)Axis.ZP.rotation(f3 * 0.015625f), 0.5f, 0.0f, 0.5f);
                } else {
                    float f4 = Mth.sin((double)(-renderState.wobbleProgress * 3.0f * (float)Math.PI)) * 0.125f;
                    float f5 = 1.0f - renderState.wobbleProgress;
                    poseStack.rotateAround((Quaternionfc)Axis.YP.rotation(f4 * f5), 0.5f, 0.0f, 0.5f);
                }
            }
        }
        this.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.potDecorations, renderState.visuallyOpen, 0);
        poseStack.popPose();
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, PotDecorationsAdapter decorations, boolean visuallyOpen, int outlineColor) {
        TextureAtlasSprite textureatlassprite = this.materials.get(DECORATED_POT);
        TextureAtlasSprite textureatlassprite2 = this.materials.get(DECORATED_POT_OPENED);
        if (decorations == null) {
            decorations = PotDecorationsAdapter.EMPTY;
        }
        if (visuallyOpen) {
            poseStack.scale(1.0f, -1.0f, -1.0f);
            RenderType renderType = DECORATED_POT_OPENED.renderType(RenderTypes::entitySolid);
            nodeCollector.submitModelPart(this.open, poseStack, renderType, packedLight, packedOverlay, textureatlassprite2, false, false, -1, null, outlineColor);
            nodeCollector.submitModelPart(this.sherds, poseStack, renderType, packedLight, packedOverlay, textureatlassprite2, false, false, -1, null, outlineColor);
        } else {
            RenderType rendertype = DECORATED_POT.renderType(RenderTypes::entitySolid);
            nodeCollector.submitModelPart(this.neck, poseStack, rendertype, packedLight, packedOverlay, textureatlassprite, false, false, -1, null, outlineColor);
            nodeCollector.submitModelPart(this.top, poseStack, rendertype, packedLight, packedOverlay, textureatlassprite, false, false, -1, null, outlineColor);
            nodeCollector.submitModelPart(this.bottom, poseStack, rendertype, packedLight, packedOverlay, textureatlassprite, false, false, -1, null, outlineColor);
            Material material = LootrDecoratedPotRenderer.getSideMaterial(decorations.front());
            nodeCollector.submitModelPart(this.frontSide, poseStack, material.renderType(RenderTypes::entitySolid), packedLight, packedOverlay, this.materials.get(material), false, false, -1, null, outlineColor);
            Material material1 = LootrDecoratedPotRenderer.getSideMaterial(decorations.back());
            nodeCollector.submitModelPart(this.backSide, poseStack, material1.renderType(RenderTypes::entitySolid), packedLight, packedOverlay, this.materials.get(material1), false, false, -1, null, outlineColor);
            Material material2 = LootrDecoratedPotRenderer.getSideMaterial(decorations.left());
            nodeCollector.submitModelPart(this.leftSide, poseStack, material2.renderType(RenderTypes::entitySolid), packedLight, packedOverlay, this.materials.get(material2), false, false, -1, null, outlineColor);
            Material material3 = LootrDecoratedPotRenderer.getSideMaterial(decorations.right());
            nodeCollector.submitModelPart(this.rightSide, poseStack, material3.renderType(RenderTypes::entitySolid), packedLight, packedOverlay, this.materials.get(material3), false, false, -1, null, outlineColor);
        }
    }

    public void getExtents(Consumer<Vector3fc> p_470536_) {
        PoseStack posestack = new PoseStack();
        this.neck.getExtentsForGui(posestack, p_470536_);
        this.top.getExtentsForGui(posestack, p_470536_);
        this.bottom.getExtentsForGui(posestack, p_470536_);
    }
}

