/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.DefaultLootFiller;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface ILootrInfo {
    public static final Set<Class<?>> WARNED_CLASSES = new HashSet();
    public static final Codec<ILootrInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LootrBlockType.CODEC.optionalFieldOf("blockType").forGetter(in -> Optional.ofNullable(in.getInfoBlockType())), (App)LootrInfoType.CODEC.optionalFieldOf("type").forGetter(in -> Optional.ofNullable(in.getInfoType())), (App)ILootrType.CODEC.optionalFieldOf("newType").forGetter(in -> Optional.ofNullable(in.getInfoNewType())), (App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(ILootrInfo::getInfoUUID), (App)Codec.STRING.fieldOf("key").forGetter(ILootrInfo::getInfoKey), (App)BlockPos.CODEC.fieldOf("position").forGetter(ILootrInfo::getInfoPos), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(i -> Optional.ofNullable(i.getInfoDisplayName())), (App)Identifier.CODEC.xmap(loc -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)loc), ResourceKey::identifier).fieldOf("dimension").forGetter(ILootrInfo::getInfoDimension), (App)Codec.INT.fieldOf("size").forGetter(ILootrInfo::getInfoContainerSize), (App)ItemStack.OPTIONAL_CODEC.listOf().xmap(list -> NonNullList.of((Object)ItemStack.EMPTY, (Object[])list.toArray(new ItemStack[0])), list -> list).optionalFieldOf("reference").forGetter(info -> info.isInfoReferenceInventory() ? Optional.ofNullable(info.getInfoReferenceInventory()) : Optional.empty()), (App)Identifier.CODEC.xmap(loc -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)loc), ResourceKey::identifier).optionalFieldOf("table").forGetter(i -> Optional.ofNullable(i.getInfoLootTable())), (App)Codec.LONG.optionalFieldOf("seed").forGetter(info -> info.getInfoLootTable() != null ? Optional.of(info.getInfoLootSeed()) : Optional.empty())).apply((Applicative)instance, BaseLootrInfo::new));

    @Deprecated
    @Nullable
    public LootrBlockType getInfoBlockType();

    @Deprecated
    @Nullable
    public LootrInfoType getInfoType();

    @Nullable
    public ILootrType getInfoNewType();

    default public LootFiller getDefaultFiller() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return DefaultLootFiller.getInstance();
        }
        return type.getDefaultFiller();
    }

    default public boolean canRefresh() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canRefresh();
    }

    default public boolean canDecay() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canDecay();
    }

    default public boolean canBeMarkedUnopened() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canBeMarkedUnopened();
    }

    default public boolean canDropContentsWhenBroken() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canDropContentsWhenBroken();
    }

    @Deprecated
    @Nullable
    default public Block getReplacementBlock() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return null;
        }
        return type.getReplacementBlock();
    }

    @Deprecated
    @Nullable
    default public EntityType<?> getReplacementEntity() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return null;
        }
        return type.getReplacementEntity();
    }

    @Deprecated
    default public boolean isEntity() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return false;
        }
        return type.isEntity();
    }

    @NotNull
    default public Vec3 getInfoVec() {
        return Vec3.atCenterOf((Vec3i)this.getInfoPos());
    }

    @NotNull
    public UUID getInfoUUID();

    public String getInfoKey();

    public static String generateInfoKey(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public boolean hasBeenOpened();

    public boolean isPhysicallyOpen();

    @NotNull
    public BlockPos getInfoPos();

    @Nullable
    public Component getInfoDisplayName();

    @NotNull
    public ResourceKey<Level> getInfoDimension();

    public int getInfoContainerSize();

    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory();

    default public boolean canPlayerOpen(ServerPlayer player) {
        return true;
    }

    default public void informPlayerCannotOpen(ServerPlayer player) {
    }

    public boolean isInfoReferenceInventory();

    @Nullable
    public ResourceKey<LootTable> getInfoLootTable();

    public long getInfoLootSeed();

    default public Level getInfoLevel() {
        if (!WARNED_CLASSES.contains(this.getClass())) {
            LootrAPI.LOG.error("Class {} does not implement `getInfoLevel`! Falling back on `getDefaultLevel`.", (Object)this.getClass().getName());
            WARNED_CLASSES.add(this.getClass());
        }
        return this.getDefaultLevel();
    }

    @Nullable
    default public Level getDefaultLevel() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            return null;
        }
        return server.getLevel(this.getInfoDimension());
    }

    @Nullable
    default public Container getInfoContainer() {
        ServerLevel level;
        Level level2 = this.getInfoLevel();
        if (!(level2 instanceof ServerLevel) || (level = (ServerLevel)level2).isClientSide()) {
            return null;
        }
        if (this.getInfoNewType() == null) {
            BlockEntity be = level.getBlockEntity(this.getInfoPos());
            if (be instanceof Container) {
                Container container = (Container)be;
                return container;
            }
            Entity entity = level.getEntity(this.getInfoUUID());
            if (entity instanceof Container) {
                Container container = (Container)entity;
                return container;
            }
            LootrAPI.LOG.warn("Unable to guess container type for LootrInfo with key '{}'", (Object)this.getInfoKey());
            return null;
        }
        return this.getInfoNewType().getContainer(this, level);
    }

    default public NonNullList<ItemStack> buildInitialInventory() {
        return NonNullList.withSize((int)this.getInfoContainerSize(), (Object)ItemStack.EMPTY);
    }

    @Deprecated
    public static enum LootrInfoType implements StringRepresentable
    {
        CONTAINER_BLOCK_ENTITY,
        CONTAINER_ENTITY;

        public static final Codec<LootrInfoType> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(LootrInfoType::values);
        }
    }
}

