/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.block.entity.LootrShulkerBlockEntity;
import noobanidus.mods.lootr.common.client.state.LootrShulkerBoxRenderState;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class LootrShulkerBoxRenderer
implements BlockEntityRenderer<LootrShulkerBlockEntity, LootrShulkerBoxRenderState> {
    public static final Material MATERIAL = new Material(Sheets.SHULKER_SHEET, LootrAPI.rl("shulker"));
    public static final Material MATERIAL2 = new Material(Sheets.SHULKER_SHEET, LootrAPI.rl("shulker_opened"));
    private final MaterialSet materials;
    private final ShulkerBoxModel model;

    public LootrShulkerBoxRenderer(BlockEntityRendererProvider.Context context) {
        this(context.entityModelSet(), context.materials());
    }

    public LootrShulkerBoxRenderer(SpecialModelRenderer.BakingContext context) {
        this(context.entityModelSet(), context.materials());
    }

    public LootrShulkerBoxRenderer(EntityModelSet modelSet, MaterialSet materials) {
        this.materials = materials;
        this.model = new ShulkerBoxModel(modelSet.bakeLayer(ModelLayers.SHULKER_BOX));
    }

    public void extractRenderState(LootrShulkerBlockEntity blockEntity, LootrShulkerBoxRenderState state, float partialTicks, Vec3 position, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)state, partialTicks, position, overlay);
        state.progress = blockEntity.getProgress(partialTicks);
        state.direction = (Direction)blockEntity.getBlockState().getValueOrElse((Property)ShulkerBoxBlock.FACING, (Comparable)Direction.UP);
        state.vanilla = LootrAPI.isVanillaTextures();
        state.classic = false;
        state.visuallyOpen = Minecraft.getInstance().player != null && blockEntity.hasClientOpened(Minecraft.getInstance().player.getUUID());
    }

    protected Material getMaterial(LootrShulkerBoxRenderState state) {
        if (state.vanilla) {
            return Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION;
        }
        if (state.visuallyOpen) {
            return MATERIAL2;
        }
        return MATERIAL;
    }

    public LootrShulkerBoxRenderState createRenderState() {
        return new LootrShulkerBoxRenderState();
    }

    public void submit(LootrShulkerBoxRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        Material material = this.getMaterial(state);
        this.submit(pose, collector, state.lightCoords, OverlayTexture.NO_OVERLAY, state.direction, state.progress, state.breakProgress, material, 0);
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, Direction direction, float progress, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, Material material, int outlineColor) {
        poseStack.pushPose();
        this.prepareModel(poseStack, direction, progress);
        nodeCollector.submitModel((Model)this.model, (Object)Float.valueOf(progress), poseStack, material.renderType(arg_0 -> ((ShulkerBoxModel)this.model).renderType(arg_0)), packedLight, packedOverlay, -1, this.materials.get(material), outlineColor, crumblingOverlay);
        poseStack.popPose();
    }

    private void prepareModel(PoseStack poseStack, Direction direction, float progress) {
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.scale(0.9995f, 0.9995f, 0.9995f);
        poseStack.mulPose((Quaternionfc)direction.getRotation());
        poseStack.scale(1.0f, -1.0f, -1.0f);
        poseStack.translate(0.0f, -1.0f, 0.0f);
        this.model.setupAnim(Float.valueOf(progress));
    }

    public void getExtents(Direction direction, float progress, Consumer<Vector3fc> output) {
        PoseStack posestack = new PoseStack();
        this.prepareModel(posestack, direction, progress);
        this.model.root().getExtentsForGui(posestack, output);
    }

    public static class ShulkerBoxModel
    extends Model<Float> {
        private final ModelPart lid;

        public ShulkerBoxModel(ModelPart root) {
            super(root, RenderTypes::entityCutoutNoCull);
            this.lid = root.getChild("lid");
        }

        public void setupAnim(Float renderState) {
            super.setupAnim((Object)renderState);
            this.lid.setPos(0.0f, 24.0f - renderState.floatValue() * 0.5f * 16.0f, 0.0f);
            this.lid.yRot = 270.0f * renderState.floatValue() * ((float)Math.PI / 180);
        }
    }
}

