/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.TickingData;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import noobanidus.mods.lootr.common.data.LootrSavedData;
import noobanidus.mods.lootr.common.mixins.AccessorMixinDimensionDataStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DataStorage {
    @Deprecated
    public static final String ADVANCEMENTS = "lootr/Lootr-AdvancementData";
    public static final String DECAYS = "lootr/Lootr-DecayData";
    public static final String REFRESHES = "lootr/Lootr-RefreshData";

    @ApiStatus.Internal
    @Nullable
    public static class_26 getDataStorage() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        class_3218 overworld = server.method_30002();
        if (overworld == null) {
            LootrAPI.LOG.error("The Overworld is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        return overworld.method_17983();
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean isAwarded(ILootrInfoProvider provider, class_3222 player) {
        return DataStorage.isAwarded(provider.getInfoUUID(), player);
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean isAwarded(UUID uuid, class_3222 player) {
        return false;
    }

    @Deprecated
    @ApiStatus.Internal
    public static void award(ILootrInfoProvider provider, class_3222 player) {
        DataStorage.award(provider.getInfoUUID(), player);
    }

    @Deprecated
    @ApiStatus.Internal
    public static void award(UUID id, class_3222 player) {
    }

    @ApiStatus.Internal
    public static int getDecayValue(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return -1;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the decay value for {}.", (Object)provider.getInfoUUID());
            return -1;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, DECAYS);
        return data.getValue(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static boolean isDecayed(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return false;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine if {} has decayed.", (Object)provider.getInfoUUID());
            return false;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, DECAYS);
        return data.isComplete(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static void setDecaying(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set the decay value for {}.", (Object)provider.getInfoUUID());
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, DECAYS);
        data.setValue(provider.getInfoUUID(), LootrAPI.getDecayValue());
    }

    @ApiStatus.Internal
    public static void removeDecayed(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr remove the decay value for {}.", (Object)provider.getInfoUUID());
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, DECAYS);
        data.remove(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static void doTick() {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot iterate and tick decay.");
            return;
        }
        ((TickingData)manager.method_17924(TickingData.FACTORY, DECAYS)).tick();
        ((TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES)).tick();
    }

    @ApiStatus.Internal
    public static int getRefreshValue(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return -1;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the refresh value for {}.", (Object)provider.getInfoUUID());
            return -1;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES);
        return data.getValue(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static boolean isRefreshed(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return false;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine if {} has refreshed.", (Object)provider.getInfoUUID());
            return false;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES);
        return data.isComplete(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static void setRefreshing(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set the refresh value for {}.", (Object)provider.getInfoUUID());
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES);
        data.setValue(provider.getInfoUUID(), LootrAPI.getRefreshValue());
    }

    @ApiStatus.Internal
    public static void removeRefreshed(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr remove the refresh value for {}.", (Object)provider.getInfoUUID());
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES);
        data.remove(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static LootrSavedData getData(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return null;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch data for {} at {} with ID {} and cannot continue.", provider.getInfoDimension(), (Object)provider.getInfoPos(), (Object)provider.getInfoUUID());
            return null;
        }
        LootrSavedData result = (LootrSavedData)manager.method_17924(new class_18.class_8645(LootrSavedData.fromInfo(provider), LootrSavedData::load, null), provider.getInfoKey());
        result.update(provider);
        return result;
    }

    @Nullable
    public static ILootrInventory getInventory(ILootrInfoProvider provider, class_3222 player, LootFiller filler) {
        LootrSavedData data = DataStorage.getData(provider);
        if (data == null) {
            return null;
        }
        return data.getOrCreateInventory(provider, player, filler);
    }

    @ApiStatus.Internal
    public static boolean clearInventories(class_1657 player) {
        return DataStorage.clearInventories(player.method_5667());
    }

    @ApiStatus.Internal
    public static boolean clearInventories(UUID id) {
        class_26 data = DataStorage.getDataStorage();
        if (data == null) {
            return false;
        }
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot clear inventories.");
            return false;
        }
        Path dataPath = server.method_27050(new class_5218("data")).resolve("lootr");
        ArrayList<String> files = new ArrayList<String>();
        try (Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);){
            paths.forEach(path -> {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String fileName = path.getFileName().toString();
                    if (fileName.startsWith("lootr-")) {
                        return;
                    }
                    files.add("lootr/" + fileName.charAt(0) + "/" + fileName.substring(0, 2) + "/" + fileName.replace(".dat", ""));
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        for (String cache : ((AccessorMixinDimensionDataStorage)data).getCache().keySet()) {
            if (!cache.startsWith("lootr") || files.contains(cache)) continue;
            files.add(cache);
        }
        int count = 0;
        for (String file : files) {
            class_1297 entity;
            class_18 datum = data.method_20786(new class_18.class_8645(() -> LootrDummyData.INSTANCE, LootrSavedData::load, null), file);
            if (datum == LootrDummyData.INSTANCE) {
                LootrAPI.LOG.error("Failed to load data for {}, removing from cache.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            if (!(datum instanceof LootrSavedData)) {
                LootrAPI.LOG.error("Data for {} is not a LootrSavedData instance.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            LootrSavedData lootrSavedData = (LootrSavedData)datum;
            if (!lootrSavedData.hasBeenOpened() || !lootrSavedData.clearInventories(id)) continue;
            ++count;
            class_3218 level = server.method_3847(lootrSavedData.getInfoDimension());
            if (level == null) continue;
            class_3215 chunkCache = level.method_14178();
            class_1923 chunkPos = new class_1923(lootrSavedData.getInfoPos());
            if (!chunkCache.method_12123(chunkPos.field_9181, chunkPos.field_9180) || !LoadedChunks.getLoadedChunks((class_5321<class_1937>)lootrSavedData.getInfoDimension()).contains(chunkPos)) continue;
            if (lootrSavedData.getInfoNewType().isEntity()) {
                entity = level.method_14190(lootrSavedData.getInfoUUID());
                if (!(entity instanceof ILootrCart)) continue;
                ILootrCart cart = (ILootrCart)entity;
                cart.removeVisualOpener(id);
                cart.performClose();
                cart.performUpdate();
                continue;
            }
            entity = level.method_8321(lootrSavedData.getInfoPos());
            ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(entity);
            if (!(iLootrBlockEntity instanceof ILootrBlockEntity)) continue;
            ILootrBlockEntity blockEntity = iLootrBlockEntity;
            blockEntity.removeVisualOpener(id);
            blockEntity.performClose();
            blockEntity.performUpdate();
        }
        if (count > 0) {
            data.method_125();
            LootrAPI.LOG.info("Cleared {} inventories for player UUID {}", (Object)count, (Object)id.toString());
            return true;
        }
        return false;
    }

    private static class LootrDummyData
    extends class_18 {
        public static final LootrDummyData INSTANCE = new LootrDummyData();

        public class_2487 method_75(class_2487 p_77763_, class_7225.class_7874 p_323640_) {
            return null;
        }
    }
}

