/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data.blockentity;

import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.replacement.BlockReplacementMap;

public interface ILootrBlockEntity
extends ILootrInfoProvider {
    public static <T extends class_2586> void ticker(class_1937 level, class_2338 pos, class_2680 state, T blockEntity) {
        ILootrBlockEntity t;
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrBlockEntity && (t = iLootrBlockEntity).hasLootTable()) {
            t.defaultTick(level, pos, state);
        }
    }

    default public boolean hasLootTable() {
        return this.getInfoLootTable() != null;
    }

    default public void defaultTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (!level.method_8608()) {
            LootrAPI.handleProviderTick(this);
        }
    }

    default public class_2586 asBlockEntity() {
        ILootrBlockEntity iLootrBlockEntity = this;
        if (iLootrBlockEntity instanceof class_2586) {
            class_2586 entity = (class_2586)iLootrBlockEntity;
            return entity;
        }
        throw new NullPointerException("ILootrBlockEntity implementation is not a BlockEntity and doesn't provide asBlockEntity()!");
    }

    @Override
    @Deprecated
    default public ILootrInfo.LootrInfoType getInfoType() {
        return ILootrInfo.LootrInfoType.CONTAINER_BLOCK_ENTITY;
    }

    default public void updatePacketViaForce() {
        this.updatePacketViaForce(this.asBlockEntity());
    }

    default public void updatePacketViaForce(class_2586 entity) {
        class_1937 class_19372 = entity.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            class_2596 packet = entity.method_38235();
            if (packet != null) {
                level.method_14178().field_17254.method_17210(new class_1923(entity.method_11016()), false).forEach(player -> player.field_13987.method_14364(packet));
            }
        }
    }

    @Override
    default public void performOpen(class_3222 player) {
        PlatformAPI.performBlockOpen(this, player);
    }

    @Override
    default public void performOpen() {
        PlatformAPI.performBlockOpen(this);
    }

    @Override
    default public void performClose(class_3222 player) {
        PlatformAPI.performBlockClose(this, player);
    }

    @Override
    default public void performClose() {
        PlatformAPI.performBlockClose(this);
    }

    @Override
    default public void performDecay() {
        class_2248 replacementBlock;
        class_1937 level = this.getInfoLevel();
        if (level == null || level.method_8608()) {
            return;
        }
        class_2680 stateAt = level.method_8320(this.getInfoPos());
        boolean replaceWhenDecayed = LootrAPI.shouldReplaceWhenDecayed();
        level.method_22352(this.getInfoPos(), !replaceWhenDecayed);
        if (replaceWhenDecayed && (replacementBlock = this.getInfoNewType().getReplacementBlock()) != null) {
            class_2680 replacementState = replacementBlock.method_9564();
            for (class_2769 prop : replacementState.method_28501()) {
                if (!stateAt.method_28498(prop)) continue;
                replacementState = BlockReplacementMap.safeReplace(replacementState, stateAt, prop);
            }
            level.method_8652(this.getInfoPos(), replacementState, 2);
        }
    }

    @Override
    default public void performUpdate(class_3222 player) {
        this.performUpdate();
    }

    @Override
    default public void performUpdate() {
        this.markChanged();
        this.updatePacketViaForce();
    }
}

