/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.data;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2621;
import net.minecraft.class_2624;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.zestyblaze.lootr.api.LootFiller;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.data.SpecialChestInventory;
import net.zestyblaze.lootr.entity.LootrChestMinecartEntity;
import net.zestyblaze.lootr.util.ServerAccessImpl;
import org.jetbrains.annotations.Nullable;

public class ChestData
extends class_18 {
    private String key;
    private class_2338 pos;
    private class_5321<class_1937> dimension;
    private UUID uuid;
    private Map<UUID, SpecialChestInventory> inventories = new HashMap<UUID, SpecialChestInventory>();
    private class_2371<class_1799> reference;
    private boolean custom;
    private boolean entity;
    private int size = -1;

    protected ChestData(String key) {
        this.key = key;
    }

    public static String ID(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public static Supplier<ChestData> ref_id(class_5321<class_1937> dimension, class_2338 pos, UUID id, class_2371<class_1799> base) {
        if (id == null) {
            throw new IllegalArgumentException("Can't create ChestData for custom container in dimension '" + dimension + "' at '" + pos + "' with a null id.");
        }
        return () -> {
            ChestData data = new ChestData(ChestData.ID(id));
            data.pos = pos;
            data.dimension = dimension;
            data.uuid = id;
            data.reference = base;
            data.custom = true;
            data.entity = false;
            if (data.reference == null) {
                throw new IllegalArgumentException("Inventory reference cannot be null.");
            }
            return data;
        };
    }

    public static Supplier<ChestData> id(class_5321<class_1937> dimension, class_2338 pos, UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("Can't create ChestData for container in dimension '" + dimension + "' at '" + pos + "' with a null id.");
        }
        return () -> {
            ChestData data = new ChestData(ChestData.ID(id));
            data.pos = pos;
            data.dimension = dimension;
            data.uuid = id;
            data.reference = null;
            data.custom = false;
            data.entity = false;
            return data;
        };
    }

    public static Supplier<ChestData> entity(class_5321<class_1937> dimension, class_2338 pos, UUID entityId) {
        if (entityId == null) {
            throw new IllegalArgumentException("Can't create ChestData for minecart in dimension '" + dimension + "' at '" + pos + "' with a null entityId.");
        }
        return () -> {
            ChestData data = new ChestData(ChestData.ID(entityId));
            data.pos = pos;
            data.dimension = dimension;
            data.uuid = entityId;
            data.entity = true;
            data.reference = null;
            data.custom = false;
            return data;
        };
    }

    public static Function<class_2487, ChestData> loadWrapper(UUID id, class_5321<class_1937> dimension, class_2338 position) {
        return tag -> {
            ChestData result = ChestData.load(tag);
            result.key = ChestData.ID(id);
            result.dimension = dimension;
            result.pos = position;
            return result;
        };
    }

    public static ChestData unwrap(ChestData data, UUID id, class_5321<class_1937> dimension, class_2338 position, int size) {
        data.key = ChestData.ID(id);
        data.dimension = dimension;
        data.pos = position;
        data.setSize(size);
        return data;
    }

    public static ChestData load(class_2487 compound) {
        ChestData data = new ChestData(compound.method_10558("key"));
        data.inventories.clear();
        data.pos = null;
        data.dimension = null;
        if (compound.method_10573("position", 4)) {
            data.pos = class_2338.method_10092((long)compound.method_10537("position"));
        } else if (compound.method_10573("position", 10)) {
            data.pos = class_2512.method_10691((class_2487)compound.method_10562("position"));
        }
        if (compound.method_10545("dimension")) {
            data.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(compound.method_10558("dimension")));
        }
        boolean foundNewUUID = false;
        if (compound.method_25928("uuid")) {
            data.uuid = compound.method_25926("uuid");
            foundNewUUID = true;
        }
        boolean foundEntity = false;
        if (compound.method_25928("entityId")) {
            if (data.uuid != null) {
                LootrAPI.LOG.error("Loaded an `entityId` from an already-migrated file: '" + data.key + "'");
            }
            data.uuid = compound.method_25926("entityId");
            data.entity = true;
            foundEntity = true;
        }
        if (compound.method_25928("tileId")) {
            if (data.uuid != null) {
                if (foundEntity && !foundNewUUID) {
                    LootrAPI.LOG.error("Loaded a `tileId` from an unmigrated file that also has `entityId`: '" + data.key + "'");
                } else if (foundEntity) {
                    LootrAPI.LOG.error("Loaded a `tileId` from an already-migrated file that also had an `entityId`: '" + data.key + "'");
                } else if (foundNewUUID) {
                    LootrAPI.LOG.error("Loaded a `tileId` from an already-migrated file: '" + data.key + "'");
                }
            }
            data.uuid = compound.method_25926("tileId");
            data.entity = false;
        }
        if (compound.method_10545("custom")) {
            data.custom = compound.method_10577("custom");
        }
        if (compound.method_10545("entity")) {
            data.entity = compound.method_10577("entity");
        }
        if (compound.method_25928("customId")) {
            LootrAPI.LOG.error("Loaded a `customId` from an old file when this field was never used. File was '" + data.key + "'");
            data.uuid = compound.method_25926("customId");
            data.entity = false;
            data.custom = true;
        }
        if (compound.method_10545("reference") && compound.method_10545("referenceSize")) {
            int size;
            data.size = size = compound.method_10550("referenceSize");
            data.reference = class_2371.method_10213((int)data.size, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)compound.method_10562("reference"), data.reference);
        }
        if (compound.method_10573("size", 3)) {
            data.size = compound.method_10550("size");
        } else if (!compound.method_10545("referenceSize")) {
            LootrAPI.LOG.error("Loaded a data file with no size: '" + data.key + "' located in dimension '" + data.dimension + "' at '" + data.pos + "'. Sizes will be guessed and updated in future. This message will only appear once; if it occurs multiple times for the same location, please report on GitHub.");
        }
        class_2499 compounds = compound.method_10554("inventories", 10);
        if (data.size == -1) {
            int maxSlot = -1;
            for (int i = 0; i < compounds.size(); ++i) {
                class_2487 thisTag = compounds.method_10602(i);
                class_2499 items = thisTag.method_10562("chest").method_10554("Items", 10);
                for (int j = 0; j < items.size(); ++j) {
                    class_2487 itemTag = items.method_10602(j);
                    int slot = itemTag.method_10571("Slot") & 0xFF;
                    if (slot <= maxSlot) continue;
                    maxSlot = slot;
                }
            }
            data.size = maxSlot % 9 == 0 ? maxSlot : maxSlot + (9 - maxSlot % 9);
        }
        for (int i = 0; i < compounds.size(); ++i) {
            class_2487 thisTag = compounds.method_10602(i);
            class_2487 items = thisTag.method_10562("chest");
            String name = thisTag.method_10558("name");
            UUID uuid = thisTag.method_25926("uuid");
            data.inventories.put(uuid, new SpecialChestInventory(data, items, name));
        }
        return data;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public String getKey() {
        return this.key;
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    public int getSize() {
        return this.size;
    }

    private void setSize(int size) {
        if (this.size == size) {
            return;
        }
        if (size < this.size) {
            throw new IllegalArgumentException("Cannot resize inventory associated with '" + this.getKey() + "' in dimension '" + this.getDimension() + "' at location '" + this.getPos() + "' to a smaller size.");
        }
        this.size = size;
        for (SpecialChestInventory inventory : this.inventories.values()) {
            inventory.resizeInventory(size);
        }
    }

    @Nullable
    public UUID getEntityId() {
        if (this.entity) {
            return this.uuid;
        }
        return null;
    }

    @Nullable
    public UUID getTileId() {
        if (!this.entity) {
            return this.uuid;
        }
        return null;
    }

    public boolean isEntity() {
        return this.entity;
    }

    public LootFiller customInventory() {
        return (player, inventory, table, seed) -> {
            for (int i = 0; i < this.reference.size(); ++i) {
                inventory.method_5447(i, ((class_1799)this.reference.get(i)).method_7972());
            }
        };
    }

    public boolean clearInventory(UUID uuid) {
        return this.inventories.remove(uuid) != null;
    }

    @Nullable
    public SpecialChestInventory getInventory(class_3222 player) {
        return this.getInventory(player.method_5667());
    }

    @Nullable
    public SpecialChestInventory getInventory(UUID id) {
        return this.inventories.get(id);
    }

    public SpecialChestInventory createInventory(class_3222 player, LootFiller filler, IntSupplier sizeSupplier, Supplier<class_2561> displaySupplier, Supplier<class_2960> tableSupplier, LongSupplier seedSupplier) {
        class_3218 level = (class_3218)player.method_37908();
        if (level.method_27983() != this.dimension) {
            MinecraftServer server = ServerAccessImpl.getServer();
            if (server == null) {
                return null;
            }
            level = server.method_3847(this.dimension);
        }
        if (level == null) {
            return null;
        }
        class_2371 items = class_2371.method_10213((int)sizeSupplier.getAsInt(), (Object)class_1799.field_8037);
        SpecialChestInventory result = new SpecialChestInventory(this, (class_2371<class_1799>)items, displaySupplier.get());
        filler.unpackLootTable((class_1657)player, result, tableSupplier.get(), seedSupplier.getAsLong());
        this.inventories.put(player.method_5667(), result);
        this.method_80();
        return result;
    }

    public SpecialChestInventory createInventory(class_3222 player, LootFiller filler, class_2624 blockEntity, Supplier<class_2960> tableSupplier, LongSupplier seedSupplier) {
        class_3218 level = (class_3218)player.method_37908();
        if (level.method_27983() != this.dimension) {
            MinecraftServer server = ServerAccessImpl.getServer();
            if (server == null) {
                return null;
            }
            level = server.method_3847(this.dimension);
        }
        if (level == null) {
            return null;
        }
        class_2371 items = class_2371.method_10213((int)blockEntity.method_5439(), (Object)class_1799.field_8037);
        SpecialChestInventory result = new SpecialChestInventory(this, (class_2371<class_1799>)items, blockEntity.method_5476());
        filler.unpackLootTable((class_1657)player, result, tableSupplier.get(), seedSupplier.getAsLong());
        this.inventories.put(player.method_5667(), result);
        this.method_80();
        return result;
    }

    public SpecialChestInventory createInventory(class_3222 player, LootFiller filler, @Nullable class_2621 tile) {
        class_2960 lootTable;
        SpecialChestInventory result;
        class_3218 world = (class_3218)player.method_37908();
        long seed = -1L;
        if (this.entity) {
            class_1297 initial = world.method_14190(this.uuid);
            if (!(initial instanceof LootrChestMinecartEntity)) {
                return null;
            }
            LootrChestMinecartEntity cart = (LootrChestMinecartEntity)initial;
            class_2371 items = class_2371.method_10213((int)cart.method_5439(), (Object)class_1799.field_8037);
            result = new SpecialChestInventory(this, (class_2371<class_1799>)items, cart.method_5476());
            lootTable = cart.field_7734;
        } else {
            if (tile == null) {
                return null;
            }
            lootTable = ((ILootBlockEntity)tile).getTable();
            class_2371 items = class_2371.method_10213((int)tile.method_5439(), (Object)class_1799.field_8037);
            result = new SpecialChestInventory(this, (class_2371<class_1799>)items, tile.method_5476());
        }
        filler.unpackLootTable((class_1657)player, result, lootTable, seed);
        this.inventories.put(player.method_5667(), result);
        this.method_80();
        return result;
    }

    public class_2487 method_75(class_2487 compound) {
        if (this.key != null) {
            compound.method_10582("key", this.key);
        } else {
            LootrAPI.LOG.error("Attempted to save a data file with no key! How could this happen?" + this);
        }
        if (this.pos != null) {
            compound.method_10566("position", (class_2520)class_2512.method_10692((class_2338)this.pos));
        } else {
            LootrAPI.LOG.error("Attempted to save a data file with no `position`: '" + this.key + "'");
        }
        if (this.dimension != null) {
            compound.method_10582("dimension", this.dimension.method_29177().toString());
        } else {
            LootrAPI.LOG.error("Attempted to save a data file with no `dimension`: '" + this.key + "'");
        }
        if (this.uuid == null) {
            throw new IllegalStateException("Attempted to save a data file with no `uuid`: '" + this.key + "'. Located in dimension '" + this.dimension + "' at '" + this.pos + "'. This is an unrecoverable error.");
        }
        compound.method_25927("uuid", this.uuid);
        compound.method_10556("custom", this.custom);
        compound.method_10556("entity", this.entity);
        compound.method_10569("size", this.size);
        if (this.reference != null) {
            compound.method_10569("referenceSize", this.reference.size());
            compound.method_10566("reference", (class_2520)class_1262.method_5427((class_2487)new class_2487(), this.reference, (boolean)true));
        }
        class_2499 compounds = new class_2499();
        for (Map.Entry<UUID, SpecialChestInventory> entry : this.inventories.entrySet()) {
            class_2487 thisTag = new class_2487();
            thisTag.method_25927("uuid", entry.getKey());
            thisTag.method_10566("chest", (class_2520)entry.getValue().writeItems());
            thisTag.method_10582("name", entry.getValue().writeName());
            compounds.add((Object)thisTag);
        }
        compound.method_10566("inventories", (class_2520)compounds);
        return compound;
    }

    public void clear() {
        this.inventories.clear();
    }

    public void method_17919(File pFile) {
        if (this.method_79()) {
            pFile.getParentFile().mkdirs();
        }
        super.method_17919(pFile);
    }
}

