/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.zestyblaze.lootr.LootrTags;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.entity.LootrChestMinecartEntity;
import net.zestyblaze.lootr.init.ModBlocks;
import net.zestyblaze.lootr.util.ServerAccessImpl;

@Config(name="lootr")
public class ConfigManager
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static ClientConfigStore clientConfigStore = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> DECAY_MODS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_2960> DECAY_TABLES = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> REFRESH_MODS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_2960> REFRESH_TABLES = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> DIM_WHITELIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> DIM_MODID_WHITELIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> DIM_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> DIM_MODID_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> DECAY_DIMS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> REFRESH_DIMS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_2960> LOOT_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Map<class_2248, class_2248> replacements = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> LOOT_MODIDS = null;
    @ConfigEntry.Gui.CollapsibleObject
    public Debug debug = new Debug();
    @ConfigEntry.Gui.CollapsibleObject
    public Seed seed = new Seed();
    @ConfigEntry.Gui.CollapsibleObject
    public Conversion conversion = new Conversion();
    @ConfigEntry.Gui.CollapsibleObject
    public Breaking breaking = new Breaking();
    @ConfigEntry.Gui.CollapsibleObject
    public Lists lists = new Lists();
    @ConfigEntry.Gui.CollapsibleObject
    public Decay decay = new Decay();
    @ConfigEntry.Gui.CollapsibleObject
    public Refresh refresh = new Refresh();
    @ConfigEntry.Gui.CollapsibleObject
    public Notifications notifications = new Notifications();
    @ConfigEntry.Gui.CollapsibleObject
    public Client client = new Client();

    public static void reset() {
        DECAY_MODS = null;
        DECAY_TABLES = null;
        REFRESH_MODS = null;
        DIM_WHITELIST = null;
        DIM_MODID_WHITELIST = null;
        DIM_BLACKLIST = null;
        DIM_MODID_BLACKLIST = null;
        DECAY_DIMS = null;
        REFRESH_DIMS = null;
        LOOT_BLACKLIST = null;
        LOOT_MODIDS = null;
    }

    private static Set<String> validateStringList(List<String> incomingList, String listKey) {
        HashSet<String> validatedList = new HashSet<String>();
        for (String entry : incomingList) {
            if (entry == null || entry.isEmpty()) {
                LootrAPI.LOG.error("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a String.");
                continue;
            }
            validatedList.add(entry);
        }
        return validatedList;
    }

    private static Set<class_5321<class_1937>> validateDimensions(List<String> incomingList, String listKey) {
        HashSet<class_5321<class_1937>> validatedList = new HashSet<class_5321<class_1937>>();
        for (String entry : incomingList) {
            if (entry == null || entry.isEmpty()) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a dimension identifier.");
            }
            try {
                validatedList.add((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(entry)));
            }
            catch (Exception e) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. The value found in the list, '" + entry + "', is not a valid dimension identifier.", e);
            }
        }
        return validatedList;
    }

    private static Set<class_2960> validateResourceLocationList(List<String> incomingList, String listKey) {
        HashSet<class_2960> validatedList = new HashSet<class_2960>();
        for (String entry : incomingList) {
            if (entry == null || entry.isEmpty()) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a ResourceLocation.");
            }
            try {
                validatedList.add(new class_2960(entry));
            }
            catch (Exception e) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. The value found in the list, '" + entry + "', is not a valid ResourceLocation.", e);
            }
        }
        return validatedList;
    }

    public static ConfigManager get() {
        return (ConfigManager)AutoConfig.getConfigHolder(ConfigManager.class).getConfig();
    }

    public static boolean isDecaying(class_3218 level, ILootBlockEntity tile) {
        if (ConfigManager.get().decay.decay_all) {
            return true;
        }
        if (tile.getTable() != null) {
            if (ConfigManager.getDecayingTables().contains(tile.getTable())) {
                return true;
            }
            if (ConfigManager.getDecayMods().contains(tile.getTable().method_12836())) {
                return true;
            }
        }
        return ConfigManager.isDimensionDecaying((class_5321<class_1937>)level.method_27983());
    }

    public static boolean isDecaying(class_3218 level, LootrChestMinecartEntity entity) {
        if (ConfigManager.get().decay.decay_all) {
            return true;
        }
        if (entity.field_7734 != null) {
            if (ConfigManager.getDecayingTables().contains(entity.field_7734)) {
                return true;
            }
            if (ConfigManager.getDecayMods().contains(entity.field_7734.method_12836())) {
                return true;
            }
        }
        return ConfigManager.isDimensionDecaying((class_5321<class_1937>)level.method_27983());
    }

    public static boolean isRefreshing(class_3218 level, LootrChestMinecartEntity entity) {
        if (ConfigManager.get().refresh.refresh_all) {
            return true;
        }
        if (entity.field_7734 != null) {
            if (ConfigManager.getRefreshingTables().contains(entity.field_7734)) {
                return true;
            }
            if (ConfigManager.getDecayMods().contains(entity.field_7734.method_12836())) {
                return true;
            }
        }
        return ConfigManager.isDimensionRefreshing((class_5321<class_1937>)level.method_27983());
    }

    public static Set<class_2960> getDecayingTables() {
        if (DECAY_TABLES == null) {
            DECAY_TABLES = ConfigManager.validateResourceLocationList(ConfigManager.get().decay.decay_loot_tables, "decay_loot_tables");
        }
        return DECAY_TABLES;
    }

    public static Set<String> getDecayMods() {
        if (DECAY_MODS == null) {
            DECAY_MODS = ConfigManager.validateStringList(ConfigManager.get().decay.decay_modids, "decay_modids");
        }
        return DECAY_MODS;
    }

    public static boolean isDimensionDecaying(class_5321<class_1937> key) {
        return ConfigManager.getDecayDimensions().contains(key);
    }

    public static Set<class_5321<class_1937>> getDecayDimensions() {
        if (DECAY_DIMS == null) {
            DECAY_DIMS = ConfigManager.validateDimensions(ConfigManager.get().decay.decay_dimensions, "decay_dimensions");
        }
        return DECAY_DIMS;
    }

    public static boolean isRefreshing(class_3218 level, ILootBlockEntity tile) {
        if (ConfigManager.get().refresh.refresh_all) {
            return true;
        }
        if (tile.getTable() != null) {
            if (ConfigManager.getRefreshingTables().contains(tile.getTable())) {
                return true;
            }
            if (ConfigManager.getRefreshMods().contains(tile.getTable().method_12836())) {
                return true;
            }
        }
        return ConfigManager.isDimensionRefreshing((class_5321<class_1937>)level.method_27983());
    }

    public static Set<class_2960> getRefreshingTables() {
        if (REFRESH_TABLES == null) {
            REFRESH_TABLES = ConfigManager.validateResourceLocationList(ConfigManager.get().refresh.refresh_loot_tables, "refresh_loot_tables");
        }
        return REFRESH_TABLES;
    }

    public static Set<String> getRefreshMods() {
        if (REFRESH_MODS == null) {
            REFRESH_MODS = ConfigManager.validateStringList(ConfigManager.get().refresh.refresh_modids, "refresh_modids");
        }
        return REFRESH_MODS;
    }

    public static boolean isDimensionRefreshing(class_5321<class_1937> key) {
        return ConfigManager.getRefreshDimensions().contains(key);
    }

    public static Set<class_5321<class_1937>> getRefreshDimensions() {
        if (REFRESH_DIMS == null) {
            REFRESH_DIMS = ConfigManager.validateDimensions(ConfigManager.get().refresh.refresh_dimensions, "refresh_dimensions");
        }
        return REFRESH_DIMS;
    }

    public static class_2680 replacement(class_2680 original) {
        class_2248 replacement;
        if (replacements == null) {
            replacements = new HashMap<class_2248, class_2248>();
        }
        if ((replacement = replacements.get(original.method_26204())) == null && (original.method_26164(LootrTags.Blocks.CONVERT_BARRELS) || original.method_26164(LootrTags.Blocks.CONVERT_CHESTS) || original.method_26164(LootrTags.Blocks.CONVERT_CHESTS) || original.method_26164(LootrTags.Blocks.CONVERT_SHULKERS) || original.method_26164(LootrTags.Blocks.CONVERT_TRAPPED_CHESTS))) {
            class_2343 entityBlock;
            class_2586 be;
            class_2248 class_22482 = original.method_26204();
            if (class_22482 instanceof class_2343 && (be = (entityBlock = (class_2343)class_22482).method_10123(class_2338.field_10980, original)) instanceof class_2621) {
                if (original.method_26164(LootrTags.Blocks.CONVERT_TRAPPED_CHESTS)) {
                    replacements.put(original.method_26204(), (class_2248)ModBlocks.TRAPPED_CHEST);
                } else if (original.method_26164(LootrTags.Blocks.CONVERT_BARRELS)) {
                    replacements.put(original.method_26204(), (class_2248)ModBlocks.BARREL);
                } else if (original.method_26164(LootrTags.Blocks.CONVERT_CHESTS)) {
                    replacements.put(original.method_26204(), (class_2248)ModBlocks.CHEST);
                } else if (original.method_26164(LootrTags.Blocks.CONVERT_SHULKERS)) {
                    replacements.put(original.method_26204(), (class_2248)ModBlocks.SHULKER);
                }
            }
            replacement = replacements.get(original.method_26204());
        }
        if (replacement != null) {
            return ConfigManager.copyProperties(replacement.method_9564(), original);
        }
        return null;
    }

    private static class_2680 copyProperties(class_2680 state, class_2680 original) {
        for (class_2769 prop : original.method_28501()) {
            if (!state.method_28498(prop)) continue;
            state = ConfigManager.safeReplace(state, original, prop);
        }
        return state;
    }

    private static <V extends Comparable<V>> class_2680 safeReplace(class_2680 state, class_2680 original, class_2769<V> property) {
        if (property == class_2281.field_10770 && state.method_28498(property)) {
            return (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12569);
        }
        if (original.method_28498(property) && state.method_28498(property)) {
            return (class_2680)state.method_11657(property, original.method_11654(property));
        }
        return state;
    }

    public static boolean isVanillaTextures() {
        return ConfigManager.get().client.vanilla_textures;
    }

    public static Set<String> getDimensionModidWhitelist() {
        if (DIM_MODID_WHITELIST == null) {
            DIM_MODID_WHITELIST = ConfigManager.validateStringList(ConfigManager.get().lists.dimension_modid_whitelist, "dimension_modid_whitelist");
        }
        return DIM_MODID_WHITELIST;
    }

    public static Set<class_5321<class_1937>> getDimensionWhitelist() {
        if (DIM_WHITELIST == null) {
            DIM_WHITELIST = ConfigManager.validateDimensions(ConfigManager.get().lists.dimension_whitelist, "dimension_whitelist");
        }
        return DIM_WHITELIST;
    }

    public static Set<String> getDimensionModidBlacklist() {
        if (DIM_MODID_BLACKLIST == null) {
            DIM_MODID_BLACKLIST = ConfigManager.validateStringList(ConfigManager.get().lists.dimension_modid_blacklist, "dimension_modid_blacklist");
        }
        return DIM_MODID_BLACKLIST;
    }

    public static Set<class_5321<class_1937>> getDimensionBlacklist() {
        if (DIM_BLACKLIST == null) {
            DIM_BLACKLIST = ConfigManager.validateDimensions(ConfigManager.get().lists.dimension_blacklist, "dimension_blacklist");
        }
        return DIM_BLACKLIST;
    }

    public static Set<String> getLootModids() {
        if (LOOT_MODIDS == null) {
            LOOT_MODIDS = ConfigManager.validateStringList(ConfigManager.get().lists.loot_modid_blacklist, "loot_modid_blacklist");
        }
        return LOOT_MODIDS;
    }

    public static Set<class_2960> getLootBlacklist() {
        if (LOOT_BLACKLIST == null) {
            LOOT_BLACKLIST = ConfigManager.validateResourceLocationList(ConfigManager.get().lists.loot_table_blacklist, "loot_table_blacklist");
        }
        return LOOT_BLACKLIST;
    }

    public static boolean isDimensionBlacklisted(class_5321<class_1937> key) {
        if (!ConfigManager.getDimensionModidWhitelist().isEmpty() && !ConfigManager.getDimensionModidWhitelist().contains(key.method_29177().method_12836()) || ConfigManager.getDimensionModidBlacklist().contains(key.method_29177().method_12836())) {
            return true;
        }
        return !ConfigManager.getDimensionWhitelist().isEmpty() && !ConfigManager.getDimensionWhitelist().contains(key) || ConfigManager.getDimensionBlacklist().contains(key);
    }

    public static boolean isBlacklisted(class_2960 table) {
        if (ConfigManager.getLootBlacklist().contains(table)) {
            return true;
        }
        return ConfigManager.getLootModids().contains(table.method_12836());
    }

    public static boolean shouldNotify(int remaining) {
        int delay = ConfigManager.get().notifications.notification_delay;
        return !ConfigManager.get().notifications.disable_notifications && (delay == -1 || remaining <= delay);
    }

    public static boolean isBreakDisabled() {
        MinecraftServer server = ServerAccessImpl.getServer();
        if (server != null) {
            return ConfigManager.get().breaking.disable_break;
        }
        if (clientConfigStore != null) {
            return ConfigManager.clientConfigStore.disableBreak;
        }
        return ConfigManager.get().breaking.disable_break;
    }

    public static class Debug {
        public boolean report_invalid_tables = true;
    }

    public static class Seed {
        public boolean randomize_seed = true;
    }

    public static class Conversion {
        public int max_entry_age = 12000;
        public boolean disable = false;
        public boolean elytra = true;
        public boolean world_border = false;
    }

    public static class Breaking {
        public boolean bypass_spawn_protection = true;
        public boolean enable_break = false;
        public boolean enable_fake_player_break = false;
        public boolean disable_break = false;
        public boolean power_comparators = true;
        public boolean blast_resistant = false;
        public boolean blast_immune = false;
        public boolean trapped_custom = false;
    }

    public static class Lists {
        public List<String> dimension_whitelist = List.of();
        public List<String> dimension_blacklist = List.of();
        public List<String> dimension_modid_blacklist = List.of();
        public List<String> dimension_modid_whitelist = List.of();
        public List<String> loot_table_blacklist = List.of();
        public List<String> loot_modid_blacklist = List.of();
    }

    public static class Decay {
        public int decay_value = 6000;
        public boolean decay_all = false;
        public List<String> decay_modids = List.of();
        public List<String> decay_loot_tables = List.of();
        public List<String> decay_dimensions = List.of();
    }

    public static class Refresh {
        public int refresh_value = 24000;
        public boolean refresh_all = false;
        public List<String> refresh_modids = List.of();
        public List<String> refresh_loot_tables = List.of();
        public List<String> refresh_dimensions = List.of();
    }

    public static class Notifications {
        public int notification_delay = 600;
        public boolean disable_notifications = false;
        public boolean disable_message_styles = false;
    }

    public static class Client {
        public boolean vanilla_textures = false;
        public boolean old_textures = false;
    }

    public static class ClientConfigStore {
        public boolean disableBreak = false;
    }
}

