/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.pricklemc.common.api.config.comment;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.darkhax.pricklemc.common.api.config.comment.Comment;
import net.darkhax.pricklemc.common.api.config.comment.IComment;

public final class CommentTypeAdapter
implements JsonSerializer<IComment>,
JsonDeserializer<IComment> {
    public static final CommentTypeAdapter INSTANCE = new CommentTypeAdapter();

    private CommentTypeAdapter() {
    }

    public IComment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return new Comment(primitive.getAsString());
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            String[] comments = new String[array.size()];
            for (int i = 0; i < comments.length; ++i) {
                JsonPrimitive primitive2;
                JsonElement jsonElement = array.get(i);
                if (!(jsonElement instanceof JsonPrimitive) || !(primitive2 = (JsonPrimitive)jsonElement).isString()) {
                    throw new JsonParseException("Comments can only contain strings. Found " + String.valueOf(array.get(i)));
                }
                comments[i] = primitive2.getAsString();
            }
            return new Comment(comments);
        }
        throw new JsonParseException("Comments can only be defined as a string or a string array. Found " + String.valueOf(json));
    }

    public JsonElement serialize(IComment src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.getLines().length == 1) {
            return new JsonPrimitive(src.getLines()[0]);
        }
        JsonArray array = new JsonArray();
        for (String line : src.getLines()) {
            array.add(line);
        }
        return array;
    }
}

