/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.pricklemc.common.impl.config.property;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import net.darkhax.pricklemc.common.api.annotations.Value;
import net.darkhax.pricklemc.common.api.config.PropertyResolver;
import net.darkhax.pricklemc.common.api.config.comment.IComment;
import net.darkhax.pricklemc.common.api.config.property.IPropertyAdapter;
import net.darkhax.pricklemc.common.api.config.property.ObjectProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.Identifier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CodecProperty<T>
extends ObjectProperty<T> {
    public static final Adapter<Identifier> IDENTIFIER = CodecProperty.of(Identifier.class, Identifier.CODEC);
    public static final Adapter<BlockPos> BLOCK_POS = CodecProperty.of(BlockPos.class, BlockPos.CODEC);
    public static final Adapter<Component> TEXT_COMPONENT = CodecProperty.of(Component.class, ComponentSerialization.CODEC);
    public static final Adapter<Style> TEXT_STYLE = CodecProperty.of(Style.class, Style.Serializer.CODEC);
    public static final Adapter<MobEffectInstance> EFFECT_INSTANCE = CodecProperty.of(MobEffectInstance.class, MobEffectInstance.CODEC);
    public static final Adapter<AttributeModifier> ATTRIBUTE_MODIFIER = CodecProperty.of(AttributeModifier.class, AttributeModifier.CODEC);
    public static final Adapter<ItemStack> ITEM_STACK = CodecProperty.of(ItemStack.class, ItemStack.CODEC);
    public static final Adapter<Ingredient> INGREDIENT = CodecProperty.of(Ingredient.class, Ingredient.CODEC);
    private final Codec<T> codec;

    public CodecProperty(Field field, Object parent, T defaultValue, Value valueMeta, IComment comment, Codec<T> codec) {
        super(field, parent, defaultValue, valueMeta, comment);
        this.codec = codec;
    }

    @Override
    public void writeValue(T value, JsonWriter writer, PropertyResolver resolver, Logger logger) throws IOException {
        JsonElement json = (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow();
        Streams.write((JsonElement)json, (JsonWriter)writer);
    }

    @Override
    public T readValue(JsonReader reader, PropertyResolver resolver, Logger logger) throws IOException {
        JsonElement json = Streams.parse((JsonReader)reader);
        return (T)((Pair)this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
    }

    public static <T> Adapter<T> of(Type classType, Codec<T> codec) {
        return new Adapter<T>(classType, codec);
    }

    public static class Adapter<T>
    implements IPropertyAdapter<CodecProperty<T>> {
        private final Type type;
        private final Codec<T> codec;

        private Adapter(Type type, Codec<T> codec) {
            this.type = type;
            this.codec = codec;
        }

        @Override
        @Nullable
        public CodecProperty<T> toValue(PropertyResolver resolver, Field field, Object parent, @Nullable Object value, Value valueMeta) throws IOException {
            if (field.getGenericType().equals(this.type)) {
                return new CodecProperty<Object>(field, parent, value, valueMeta, resolver.toComment(field, value, valueMeta), this.codec);
            }
            return null;
        }
    }
}

