/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.pricklemc.common.api.config.property;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import net.darkhax.pricklemc.common.api.annotations.Value;
import net.darkhax.pricklemc.common.api.config.ConfigObjectSerializer;
import net.darkhax.pricklemc.common.api.config.PropertyResolver;
import net.darkhax.pricklemc.common.api.config.comment.IComment;
import net.darkhax.pricklemc.common.api.config.property.IPropertyAdapter;
import net.darkhax.pricklemc.common.api.config.property.ObjectProperty;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ConfigObjectProperty<T>
extends ObjectProperty<T> {
    private final ConfigObjectSerializer<?> serializer;

    private ConfigObjectProperty(Field field, Object parent, T defaultValue, Value valueMeta, ConfigObjectSerializer<?> serializer, IComment comment) {
        super(field, parent, defaultValue, valueMeta, comment);
        this.serializer = serializer;
    }

    @Override
    public void writeValue(T value, JsonWriter writer, PropertyResolver resolver, Logger logger) throws IOException {
        this.serializer.write(writer);
    }

    @Override
    public void read(JsonReader reader, PropertyResolver resolver, Logger logger) throws IOException {
        reader.beginObject();
        while (reader.hasNext()) {
            if ("value".equals(reader.nextName())) {
                this.serializer.read(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    public static IPropertyAdapter<?> adapter(PropertyResolver resolver) {
        return new Adapter(resolver);
    }

    private record Adapter(PropertyResolver resolver) implements IPropertyAdapter<ConfigObjectProperty<?>>
    {
        @Override
        @Nullable
        public ConfigObjectProperty<?> toValue(PropertyResolver resolver, Field field, Object parent, Object value, Value valueMeta) throws IOException {
            if (Adapter.isConfigObject(value)) {
                ConfigObjectSerializer<Object> serializer = new ConfigObjectSerializer<Object>(resolver, value);
                return new ConfigObjectProperty<Object>(field, parent, value, valueMeta, serializer, resolver.toComment(field, value, valueMeta));
            }
            return null;
        }

        private static boolean isConfigObject(Object value) {
            for (Field subField : value.getClass().getDeclaredFields()) {
                if (subField.getAnnotation(Value.class) == null) continue;
                return true;
            }
            return false;
        }
    }
}

