package net.darkhax.ghostgear.common.impl.spiritbox;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.ghostgear.common.impl.GhostGear;
import net.minecraft.client.gui.screens.inventory.CrafterScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class SpiritBoxMenu extends AbstractContainerMenu {

    public static final CachedSupplier<MenuType<SpiritBoxMenu>> TYPE = CachedSupplier.cache(() -> BuiltInRegistries.MENU.get(GhostGear.id("spirit_box"))).cast();

    private final ContainerLevelAccess levelAccess;
    private final ContainerData data;

    public static SpiritBoxMenu clientMenu(int containerId, Inventory playerInv) {
        return new SpiritBoxMenu(TYPE.get(), containerId, new SimpleContainerData(2), ContainerLevelAccess.NULL);
    }

    public static SpiritBoxMenu serverMenu(int containerId, Inventory playerInv, SpiritBoxBlockEntity box) {
        return new SpiritBoxMenu(TYPE.get(), containerId, box.getDataAccess(), ContainerLevelAccess.create(Objects.requireNonNull(box.getLevel()), box.getBlockPos()));
    }

    protected SpiritBoxMenu(@Nullable MenuType<?> menuType, int containerId, ContainerData boxData, ContainerLevelAccess levelAccess) {
        super(menuType, containerId);
        this.levelAccess = levelAccess;
        this.data = boxData;
        this.addDataSlots(boxData);
    }

    public void cycleScanMode() {
        this.setScanMode(cycleEnum(this.getScanMode(), ScanMode.class, true));
    }

    public ScanMode getScanMode() {
        return ScanMode.values()[this.data.get(0)];
    }

    public void setScanMode(ScanMode scanMode) {
        this.setData(0, scanMode.ordinal());
    }

    public void cycleScanSpeed() {
        this.setScanSpeed(cycleEnum(this.getScanSpeed(), ScanSpeed.class, true));
    }

    public void setScanSpeed(ScanSpeed scanSpeed) {
        this.setData(1, scanSpeed.ordinal());
    }

    public ScanSpeed getScanSpeed() {
        return ScanSpeed.values()[data.get(1)];
    }

    public void setData(int id, int value) {
        super.setData(id, value);
        this.broadcastFullState();
    }

    @NotNull
    @Override
    public ItemStack quickMoveStack(@NotNull Player player, int i) {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return stillValid(this.levelAccess, player, SpiritBoxBlock.TYPE.get());
    }

    @Override
    public boolean clickMenuButton(Player player, int id) {
        switch (id) {
            case 0 -> this.cycleScanMode();
            case 1 -> this.cycleScanSpeed();
        }
        return true;
    }

    public static <T extends Enum<T>> T cycleEnum(T current, Class<T> enumClass, boolean forward) {
        final T[] values = enumClass.getEnumConstants();
        int index = current.ordinal() + (forward ? 1 : -1);
        if (index < 0) {
            index = values.length - 1;
        }
        if (index >= values.length) {
            index = 0;
        }
        return values[index];
    }
}
