package net.darkhax.ghostgear.common.impl.spiritbox;

import net.minecraft.network.chat.Component;

public enum ScanSpeed {

    RAPID(5 * 20),
    FREQUENT(10 * 20),
    STEADY(15 * 20),
    INFREQUENT(30 * 20),
    OCCASIONAL(60 * 20);

    private final int tickRate;
    private final Component displayName;
    private final Component description;

    ScanSpeed(int tickRate) {
        this.tickRate = tickRate;
        this.displayName = Component.translatable("ghostgear.spirit_box.scan_speed." + this.name().toLowerCase());
        this.description = Component.translatable("ghostgear.spirit_box.scan_speed." + this.name().toLowerCase() + ".desc");
    }

    public Component displayName() {
        return this.displayName;
    }

    public Component description() {
        return this.description;
    }

    public int scanSpeed() {
        return this.tickRate;
    }
}