package net.darkhax.ghostgear.common.impl.spiritbox;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Dictionaries {

    public static final Set<String> ALL_WORDS = new LinkedHashSet<>();
    public static final Map<String, Set<String>> DICTIONARIES = new HashMap<>();

    static {
        addWords("number", "zero", "none", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "hundred", "thousand", "dozen", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth", "once", "twice", "many", "never", "negative");
        addWords("alphabet", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
        addWords("answers", "yes", "true", "right", "no", "false", "wrong", "maybe", "unsure", "possible", "not_yet", "okay", "why", "stop", "go_on", "always", "never", "sometimes", "sometimes_not", "try_again");
        addWords("months", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december");
        addWords("zodiac", "aries", "taurus", "gemini", "cancer", "leo", "virgo", "libra", "scorpio", "sagittarius", "capricorn", "aquarius", "pisces");
        addWords("direction", "north", "south", "east", "west", "up", "down", "left", "right", "forward", "backward", "reverse", "upside_down");
        addWords("measurements", "meter", "kilometer", "inch", "foot", "pound", "kilogram", "liter", "gallon", "degree", "percent", "ratio", "volume", "area", "mass", "speed");
        addWords("technology", "computer", "phone", "tablet", "tv", "camera", "microphone", "speaker", "machine", "scanner", "headphone");
        addWords("occupations", "farmer", "blacksmith", "mage", "soldier", "priest", "hunter", "merchant", "captain", "guard", "noble", "thief", "assassin", "kin", "queen", "teacher", "shepherd", "student", "villager", "sailor", "miner", "alchemist", "chef", "researcher", "doctor", "butcher", "clerk", "judge", "jury", "pharmacist", "librarian", "chief", "forager", "officer", "inventor", "scientist", "dentist", "tailor", "banker", "investor", "glass_blower", "refiner", "engineer", "electrician", "plumber", "nurse", "pilot", "artist", "musician", "painter", "accountant", "writer", "mechanic", "journalist", "coach", "firefighter");
        addWords("relation", "wife", "husband", "son", "daughter", "mother", "father", "grandmother", "grandfather", "uncle", "aunt", "cousin", "sibling", "friend", "neighbor", "companion", "partner", "lover", "mistress", "enemy", "rival", "patient", "student", "grandchild", "step_mother", "step_father", "step_daughter", "god_parent", "niece", "nephew", "roommate", "colleague", "boss", "sister", "brother");
        addWords("colors", "white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black", "aqua", "fuchsia", "maroon", "navy", "olive", "teal", "silver", "gold");
        addWords("body_part", "head", "eye", "ear", "nose", "hand", "foot", "arm", "leg", "back", "spine", "brain", "heart", "hair", "skin", "finger", "toe", "spleen", "forehead", "scalp", "skull", "femur", "teeth", "mouth");
        addWords("names", "alice", "ben", "clara", "dave", "emma", "fred", "grace", "harry", "ida", "jack", "karen", "leo", "mia", "nick", "olivia", "paul", "quinn", "ruth", "sam", "tina", "ursula", "victor", "wendy", "xander", "yvonne", "zach", "abby", "brian", "cara", "daniel", "ella", "fiona", "george", "hannah", "ian", "julia", "kevin", "lily", "matt", "nina", "owen", "pat", "queen", "ryan", "sara", "tom", "uma", "valerie", "will", "xenia", "yara", "zane", "amelia", "blake", "carl", "diana", "eric", "faith", "gavin", "helen", "isabel", "jason", "kylie", "lance", "morgan", "nathan", "olga", "peter", "rose", "steve", "tracy", "ulysses", "violet", "wayne", "ximena", "yosef", "zoe", "adrian", "bella", "chris", "daphne", "edward", "flora", "greg", "harriet", "ivan", "joan", "keira", "marie", "noah", "ophelia", "paige", "quentin", "rita", "sebastian", "tara", "urs", "vanessa", "wade", "zachary", "ann", "bobby", "cynthia", "derek", "eva", "frank", "gina", "hugh", "iris", "joseph", "louis", "monica", "ned", "oliver", "priscilla", "rachel", "simon", "theresa", "willow", "zara", "dark_hacks");
        addWords("house", "chair", "door", "chest", "window", "floor", "table", "closet", "painting", "kitchen", "wall", "device", "radio", "well", "bed_room", "bathroom", "garage", "patio", "roof", "sofa", "lamp", "curtain", "mirror", "desk", "stove", "sink", "faucet", "hose");
        addWords("tools", "axe", "sword", "potion", "spy_glass", "pick_axe", "shovel", "bucket", "bow", "fishing_rod", "fork", "spoon", "hammer", "screwdriver", "ladder", "torch");
        addWords("clothing", "hat", "cap", "beanie", "fedora", "trilby", "top_hat", "bowler_hat", "shirt", "t_shirt", "polo_shirt", "blouse", "tank_top", "sweater", "hoodie", "jacket", "coat", "parka", "blazer", "cardigan", "vest", "pants", "jeans", "trousers", "shorts", "cargo_pants", "leggings", "sweatpants", "skirt", "dress", "gown", "shoes", "boots", "sneakers", "heels", "sandals", "slippers", "flip_flops", "gloves", "scarf", "belt", "tie", "bowtie", "suspenders", "socks", "stockings", "tights", "underwear", "boxers", "briefs", "panties", "bra", "camisole", "cloak", "cape", "raincoat", "windbreaker", "anorak", "accessories", "watch", "bracelet", "necklace", "ring", "earring", "brooch", "pin", "purse", "wallet", "handbag", "backpack", "hairband", "headband", "footwear", "hiking_boots", "work_boots", "dress_shoes", "cleats", "tuxedo", "dress_shirt", "wool_socks", "earmuffs", "mittens", "sleepwear", "pajamas", "night_gown", "robe", "sportswear", "jersey", "track_suit", "gym_shoes", "apron", "mask", "costume", "glasses", "wrist_watch");
        addWords("nature", "tree", "bush", "grass", "vine", "mushroom", "fern", "rose", "oak", "pine", "herb", "river", "wind", "sky", "stone", "leaf", "cold", "fog", "mountain", "root", "day", "sunlight", "flower", "bug", "animal", "pet", "moss", "plants", "gravel", "ground", "snow", "rain", "storm", "cloud", "lightning", "spring", "summer", "winter", "fall");
        addWords("weather", "rain", "snow", "storm", "fog", "wind", "sun", "cloud", "thunder", "lightning", "hail", "heat", "cold", "frost", "drizzle", "blizzard", "sleet", "dust", "mist", "tornado", "flood", "drought", "sunrise", "sunset", "eclipse");
        addWords("materials", "stone", "iron", "gold", "diamond", "coal", "emerald", "quartz", "obsidian", "wood", "brick", "metal", "plastic", "silver", "tin", "brass", "copper", "lead");
        addWords("spooky", "ritual", "circle", "power", "marked", "symbol", "blood", "chant", "binding", "seal", "sacrifice", "bound", "grave", "soul", "spirit", "tomb", "buried", "ash", "cross", "heaven", "hell", "beyond", "eternal", "passed", "mourning", "ghost", "death", "sick", "dying", "entity", "haunt", "specter", "presence", "shadow", "whisper", "energy", "curse", "contract", "demonic", "evil", "angel", "portal", "sigil", "summon", "hex", "charm", "phantom", "aura", "familiar", "totem", "spell", "enchantment", "mana", "essence", "conjure", "divination", "sorcery", "occult", "ritual_circle");
        addWords("emotion", "fear", "anger", "love", "joy", "hate", "sad", "alone", "sorry", "regret", "remember", "pain", "forgive", "cry", "lost", "wanting", "envy", "proud", "curious", "tired", "exhausted", "annoyed", "confused", "bored", "excited", "frustrated", "shy", "guilty");
        addWords("time", "midnight", "noon", "dawn", "dusk", "week", "month", "year", "past", "present", "future", "yesterday", "tomorrow", "forever", "once", "twice", "again", "long", "old", "moment", "always", "before", "after", "last_year", "decade", "century", "eons");
        addWords("locations", "ocean", "nether", "deep_dark", "strong_hold", "bastion", "fortress", "ruins", "ship_wreck", "beach", "plateau", "mesa", "plains", "pyramid", "farm", "homestead", "attic", "basement", "every_where", "behind_you", "above_you", "church", "grave_yard", "swamp", "desert", "mountain_side", "hill", "valley", "ravine", "river_bank", "forest", "road", "bridge", "path", "mine_shaft", "cellar", "tower", "dungeon", "village", "outpost", "house", "room", "cave", "island", "school", "hospital", "store", "office", "factory", "library", "hotel", "bus_station", "airport", "dock", "market", "arcade", "park", "mall", "museum", "zoo", "cinema", "restaurant", "cafe", "playground", "stadium", "amusement_park", "bowling_alley", "gym", "aquarium", "nightclub", "concert_hall", "theater", "garden", "station");
        addWords("textures",     "rough", "smooth", "slimy", "sticky", "bumpy", "gritty", "soft", "hard", "jagged", "fuzzy", "scratchy", "slippery", "coarse", "velvety", "waxy", "cracked", "prickly", "spongy", "glossy", "matte", "powdery", "rigid", "pliable", "wrinkled", "slick", "damp", "dry", "frosty", "crunchy", "oily", "fibrous", "spiky", "crusty", "greasy", "brittle", "chewy", "flaky", "gelatinous", "lumpy", "grainy", "shiny", "cloudy", "hollow", "dense", "porous", "slicky", "craggy", "slicked", "softened", "scaly", "matted", "shriveled", "stretchy", "stringy", "veiny", "slicked_over", "slippery_smooth", "roughened", "pitted", "wrinkly", "corrugated", "spongelike", "marbled", "clayey", "glimmering", "oily_slick", "slicked_back", "frosted", "grimy", "muddy", "polished", "buffed", "scuffed", "chipped", "fluffy", "crumpled", "twisted", "knotted", "threadbare", "coagulated", "jellylike", "sticky_wet", "shattered", "splintered", "slivered", "crinkled", "mossy", "chalky", "grainy_fine", "bubbly", "pocked", "scorched", "smudged", "blistered", "folded", "frosted_over", "weathered", "gnarled", "spongy_soft", "lacerated", "oily_resinous", "scratched_up", "pitted_surface", "mottled", "honeycombed", "knurled", "ribbed", "veined", "textured", "undulating", "dimpled", "bristly", "slicked_down", "shaggy", "worn", "pebbled", "corrugated_surface", "frayed", "torn", "slivered_edges", "matted_fur", "bumpy_surface", "grained", "pocked_surface", "wavy", "coarse_grain", "scaly_surface", "splintered_wood", "cracked_paint", "dusty");
        addWords("objects", "book", "ring", "watch", "coin", "knife", "bell", "chain", "clock", "rope", "pill", "painting", "letter", "photo", "bag", "computer", "phone", "diamond", "gem", "pants", "clothes", "lantern", "comb", "jar", "pot", "cup", "bottle", "dice", "cards", "paper", "ink", "gems", "wallet", "notebook", "pen", "pencil");
        addWords("actions", "avoid", "pray", "cast", "destroy", "touch", "leave", "run", "fight", "break", "activate", "jump", "crouch", "speak", "fly", "dry", "eat", "drink", "burn", "cook", "sleep", "push", "catch", "throw", "open", "close", "pull", "draw", "write", "build", "repair", "find", "kill", "poison", "bake", "shake", "swim", "craft", "knit", "hide", "quiet", "explore", "ignore", "stop", "continue", "pursue");
        addWords("abstract", "silence", "law", "justice", "government", "policy", "team", "club", "union", "conflict", "truth", "memory", "secret", "end", "begin", "voice", "void", "question", "answer", "body", "form", "intention", "freedom", "fate", "destiny", "illusion", "chaos", "order", "dream", "fear", "despair", "hope", "love", "anger", "envy", "pride", "courage", "curiosity", "wisdom", "time", "space", "nothingness");
        addWords("mobs", "player", "creeper", "zombie", "skeleton", "guardian", "dragon", "stray", "illager", "villager", "chicken", "sheep", "cow", "axolotl", "golem", "slime", "husk", "bug", "spider", "fish", "cat", "wolf", "dog", "frog", "bee", "pig", "rabbit", "horse", "fox", "mule", "witch", "phantom", "ghast");
        addWords("food", "egg", "cookie", "carrot", "potato", "steak", "pasta", "fish", "cake", "pie", "stew", "berry", "milk", "cheese", "cream", "nuts", "apple", "water", "chocolate", "tomato", "corn", "wheat", "bread", "snack", "vegetable", "meat", "fruit", "soup", "sandwich", "tea", "coffee", "juice");
        addWords("transportation", "boat", "cart", "carriage", "minecart", "ship", "wagon", "horse", "balloon", "bicycle", "airship", "raft", "sled", "canoe", "glider", "skates", "skateboard", "train");
        addWords("history", "empire", "revolution", "kingdom", "battle", "monument", "festival", "ceremony", "tradition", "myth", "legend", "artifact");
        addWords("science", "atom", "molecule", "cell", "gravity", "energy", "force", "plant", "animal", "ecosystem", "bacteria", "virus", "climate", "magnet", "measure", "observe", "quantum", "microscope", "telescope", "ruler", "needle");
        addWords("pronouns", "i", "me", "my", "mine", "myself", "you", "your", "yours", "yourself", "he", "him", "his", "himself", "she", "her", "hers", "herself", "it", "its", "itself", "we", "us", "our", "ours", "ourselves", "they", "them", "their", "theirs", "themselves", "this", "that", "these", "those", "someone", "anyone", "everyone", "no_one", "something", "anything", "everything", "nothing", "who", "whom", "whose", "which", "what");
        addWords("creatures", "dragon", "unicorn", "griffin", "phoenix", "mermaid", "vampire", "werewolf", "lich", "goblin", "troll", "ogre", "faerie", "banshee", "chimera", "kraken", "sphinx", "hydra", "yeti", "cerberus", "minotaur", "rock_lobster");
        addWords("adjectives", "brave", "bright", "calm", "clever", "cold", "curious", "dark", "deep", "distant", "eager", "faint", "giant", "happy", "harsh", "hollow", "jolly", "kind", "luminous", "mysterious", "narrow", "near", "noble", "odd", "patient", "peaceful", "peculiar", "polite", "poor", "powerful", "quiet", "rare", "rapid", "rich", "rough", "sad", "secret", "serene", "sharp", "shiny", "short", "silent", "simple", "small", "soft", "strange", "strong", "sudden", "tall", "thin", "tiny", "tragic", "vast", "vivid", "weak", "wild", "wise", "young", "zealous", "abandoned", "agile", "ancient", "arrogant", "ashamed", "awkward", "barren", "bleak", "bold", "boundless", "brilliant", "careful", "cheerful", "clumsy", "complex", "constant", "courageous", "cruel", "curved", "daring", "delicate", "dense", "desolate", "determined", "dreadful", "dreary", "eerie", "elated", "empty", "enormous", "enigmatic", "eternal", "exquisite", "fabulous", "faithful", "famous", "fearful", "fickle", "fierce", "filthy", "fine", "fragile", "frantic", "frozen", "funny", "furious", "gentle", "glorious", "graceful", "grim", "handsome", "harrowing", "hasty", "heavy", "hidden", "horrible", "humble", "hungry", "ideal", "immense", "imperfect", "innocent", "jealous", "jubilant", "keen", "kindhearted", "lasting", "lazy", "light", "lively", "lonely", "lost", "lucky");
        addWords("propositions", "above", "across", "after", "against", "along", "among", "around", "at", "before", "behind", "below", "beneath", "beside", "between", "beyond", "by", "down", "during", "except", "for", "from", "in", "inside", "into", "near", "of", "off", "on", "over", "through", "to", "toward", "under", "until", "up", "upon", "with", "within", "without");
        addWords("conjunctions", "and", "or", "but", "nor", "for", "so", "yet", "although", "because", "since", "unless", "while", "whereas", "if", "than", "that", "when", "after", "before", "once", "until", "whether");
        addWords("auxiliary_verbs", "am", "is", "are", "was", "were", "be", "being", "been", "do", "does", "did", "have", "has", "had", "will", "would", "shall", "should", "can", "could", "may", "might", "must");
        addWords("shape", "circle", "square", "triangle", "rectangle", "pentagon", "hexagon", "heptagon", "octagon", "nonagon", "decagon", "star", "diamond", "oval", "ellipse", "crescent", "heart", "arrow", "cross", "spiral", "parallelogram", "trapezoid", "rhombus", "kite", "polygon", "cube", "sphere", "cone", "cylinder", "pyramid", "torus", "prism", "octahedron", "dodecahedron", "icosahedron");
        addWords("toys", "ball", "doll", "action_figure", "lego", "blocks", "stuffed_animal", "teddy_bear", "train_set", "puzzle", "board_game", "yo_yo", "kite", "marbles", "jump_rope", "hula_hoop", "slingshot", "car", "rc_car", "rc_plane", "rc_boat", "model_kit", "rubik_cube", "trading_cards", "chess_set", "checkers", "mini_figures", "puppet", "hand_puppet", "play_kitchen", "dollhouse", "toy_food", "stuffed_dinosaur", "rocking_horse", "scooter", "bicycle", "tricycle", "skateboard", "roller_skates", "train_engine", "train_car", "fishing_set", "chalk", "coloring_book", "crayons", "markers", "paint_set", "tool_set", "water_gun", "bubble_wand", "stuffed_bunny", "stuffed_fox", "fashion_doll", "race_track", "fidget_spinner", "fidget_cube", "pop_it", "magic_kit", "science_kit", "robot", "drone", "playhouse", "sandbox", "shovel", "bucket", "trampoline", "swing", "slide", "play_mat", "toy_phone", "dress_up_clothes", "mask", "crown", "wand", "cape", "pirate_hat", "walkie_talkie", "binoculars", "microscope", "telescope", "paddle_ball", "frisbee", "hockey_stick", "soccer_ball", "basketball", "baseball", "bat", "glove", "skipping_rope", "balance_beam", "parachute", "card_game", "memory_game", "dominoes", "jigsaw_puzzle", "magnet_set", "sticker_set", "paint_by_numbers", "bead_set", "maze_game", "stacking_rings", "shape_sorter", "rocking_chair", "animal_figures", "dinosaurs", "farm_animals", "vehicles", "construction_vehicles", "fire_truck", "police_car", "ambulance", "airplane", "helicopter", "boat", "submarine", "roller_coaster", "marble_run", "ball_maze", "wooden_blocks", "magnetic_blocks", "construction_set", "gears_set", "stacking_blocks", "peg_board", "shape_puzzle", "math_blocks", "alphabet_blocks", "learning_tablet", "electronic_pets", "interactive_robot", "storybook_projector", "finger_paint", "chalkboard", "whiteboard", "craft_kit", "sewing_kit", "knitting_kit", "loom_bands", "water_paint", "sandcastle_molds", "mini_furniture", "mini_food", "stuffed_monkey", "stuffed_cat", "stuffed_dog", "stuffed_elephant", "stuffed_rabbit", "race_car_set", "animal_puppets", "hand_puppets", "marionette", "puppet_theater", "train_station", "garage_playset", "hospital_playset", "fire_station_playset", "police_station_playset", "farm_playset", "zoo_playset", "dinosaur_playset", "castle_playset", "pirate_ship_playset", "space_ship_playset", "rocket", "satellite", "planet", "globe", "world_map", "planetarium_projector", "light_projector", "bubble_machine", "balloon_animal", "origami", "puzzle_books", "maze_books", "sticker_books", "coloring_books", "activity_books", "play_sand", "kinetic_sand", "slime_kit", "foam_blocks", "water_table", "toy_garden_set");
        addWords("articles", "a", "an", "the");
        addWords("countries", "argentina", "australia", "brazil", "canada", "china", "egypt", "france", "germany", "india", "indonesia", "iran", "israel", "italy", "japan", "mexico", "nigeria", "pakistan", "russia", "saudi_arabia", "south_africa", "south_korea", "spain", "turkey", "united_kingdom", "united_states", "ukraine", "vietnam");
        addWords("events", "world_war_1", "world_war_2", "american_revolution", "french_revolution", "civil_war", "great_depression", "moon_landing", "cold_war", "industrial_revolution", "boston_tea_party", "pearl_harbor", "d_day", "gold_rush", "black_plague", "renaissance", "apollo_11", "tea_party", "birthday", "wedding", "anniversary", "picnic", "graduation", "family_reunion", "barbecue", "baby_shower", "holiday_party", "housewarming", "game_night", "movie_night", "concert", "festival", "parade", "sleepover", "road_trip", "hike", "shopping_trip", "dinner_party", "study_session", "crafting_session", "fishing_trip", "camping_trip");
        addWords("astronomy", "mercury", "venus", "earth", "mars", "jupiter", "saturn", "uranus", "neptune", "pluto", "moon", "io", "europa", "titan", "phobos", "deimos", "asteroid", "comet", "meteor", "meteoroid", "meteorite", "dwarf_planet", "kuiper_belt", "oort_cloud", "sun", "sirius", "vega", "rigel", "betelgeuse", "polaris", "antares", "arcturus", "deneb", "altair", "orion", "lyra", "andromeda", "cassiopeia", "ursa_major", "ursa_minor", "draco", "milky_way", "andromeda_galaxy", "black_hole", "neutron_star", "supernova", "nebula", "quasar", "pulsar", "new_moon", "waxing_crescent", "first_quarter", "waxing_gibbous", "full_moon", "waning_gibbous", "last_quarter", "waning_crescent", "harvest_moon", "blood_moon", "blue_moon", "wolf_moon", "strawberry_moon", "cold_moon", "snow_moon");
        addWords("jokes", "noodle", "wiggle", "bonk", "oof", "boo", "clown", "meow", "chicken_jockey", "oops", "kaboom", "yikes", "zoinks", "zozo");
        addWords("phrases", "i_have_the_body_of_a_pig", "i_see_you", "can_you_hear_me", "go_away", "look_out", "thank_you", "good_night", "good_morning", "good_bye", "help_me", "what_is_this", "something_is_there", "i_can_hear_it", "i_am_tired", "i_dont_feel_so_good", "let_me_in", "wait_for_me", "i_am_happy", "i_miss_you", "come_with_me", "this_is_wrong", "this_is_right", "stay_away", "i_dont_care", "i_am_scared", "i_want_my_mom", "can_you_see_me", "play_with_me", "im_so_cold", "can_you_help_me", "it_hurts_to_be_alone", "i_dropped_my_toy", "please_stay", "come_closer", "tag_your_it", "i_used_to_live_here", "he_is_behind_you", "its_just_a_game", "can_i_go_with_you", "can_i_come_home_with_you", "where_did_you_go", "where_am_i", "it_is_so_warm_here", "im_burning", "it_burns", "make_it_stop", "why_are_you_doing_this", "its_just_me", "its_safe", "im_behind_you", "we_should_hide", "your_turn", "do_you_remember", "you_cant_save_them", "its_too_late", "they_wont_forgive_you", "you_should_not_come_here", "it_wont_end_well", "you_are_not_welcome_here", "trust_me", "we_chose_you", "i_watch_over_you", "you_must_do_this_for_me", "they_lied_to_you", "they_can_not_help_you", "your_sins_follow_you", "its_too_late_for_you", "you_lied", "it_knows", "dont_move", "too_late", "too_weak", "always_here", "not_yours", "never_leave", "i_remain", "please_wait", "dont_go", "stay_here", "i_know", "come_here", "be_careful", "who_is_there", "i_cant_help_you", "i_need_a_break", "what_time_is_it", "i_am_hungry", "i_am_thirsty", "dont_touch", "call_me", "tell_her", "tell_them", "tell_him", "show_me", "happy_to_help", "you_are_in_danger", "turn_on_the_tv", "i_have_a_surprise", "be_not_afraid", "let_me_inside", "you_can_not_stay_here", "you_left_me_behind", "i_am_right_here", "why_are_you_torturing_me_like_this", "go_outside", "help_us");
        addWords("common", "the", "be", "to", "of", "and", "a", "in", "that", "have", "i", "it", "for", "not", "on", "with", "he", "as", "you", "do", "at", "this", "his", "by", "from", "they", "we", "say", "her", "she", "or", "an", "will", "my", "one", "all", "would", "there", "their", "what", "so", "up", "out", "if", "about", "who", "get", "which", "go", "me", "when", "make", "can", "time", "no", "just", "him", "know", "take", "people", "into", "year", "your", "good", "some", "could", "them", "see", "other", "than", "then", "now", "look", "only", "come", "its", "over", "think", "also", "back", "after", "use", "two", "how", "our", "work", "first", "well", "way", "even", "new", "want", "because", "any", "these", "give", "day", "most", "is", "am", "are", "was", "were", "been", "being", "has", "had", "did", "shall", "should", "may", "might", "must", "can_not", "cannot", "need", "does", "doing", "let", "lets", "too", "very", "here", "where", "why", "again", "off", "each", "every", "no_one", "some_one", "somebody", "anybody", "nobody", "everybody", "whom", "whose", "whatever", "himself", "herself", "themselves", "ourselves", "itself", "myself", "mine", "yours", "hers", "ours", "theirs", "but", "while", "although", "though", "until", "unless", "against", "between", "through", "during", "before", "above", "below", "down", "under", "further", "once", "both", "few", "more", "such", "nor", "own", "same", "i_am", "i_have", "you_are", "we_are", "they_are", "he_is", "she_is", "it_is", "i_was", "you_were", "we_were", "they_were", "he_was", "she_was", "it_was", "i_will", "you_will", "he_will", "she_will", "it_will", "we_will", "they_will", "i_can", "you_can", "he_can", "she_can", "it_can", "we_can", "they_can", "i_should", "you_should", "he_should", "she_should", "it_should", "we_should", "they_should", "i_would", "you_would", "he_would", "she_would", "it_would", "we_would", "they_would", "i_might", "you_might", "he_might", "she_might", "it_might", "we_might", "they_might", "i_must", "you_must", "he_must", "she_must", "it_must", "we_must", "they_must", "i_do", "you_do", "he_does", "she_does", "it_does", "we_do", "they_do", "i_did", "you_did", "he_did", "she_did", "it_did", "we_did", "they_did", "here_is", "there_is", "there_are", "i_think", "you_think", "he_thinks", "she_thinks", "we_think", "they_think", "last", "long", "great", "little", "old", "big", "high", "different", "small", "large", "next", "early", "young", "important", "public", "bad", "able", "to_be", "of_course", "so_far", "in_fact", "almost", "actually", "still", "yet", "sometimes", "often", "usually", "always", "never", "twice", "everywhere", "somewhere", "anywhere", "nowhere", "together", "apart", "aside", "ahead", "behind", "near", "far", "outside", "inside", "upstairs", "downstairs", "forward", "backward", "left", "right", "north", "south", "east", "west", "morning", "afternoon", "evening", "night", "today", "yesterday", "tomorrow", "week", "month", "hour", "minute", "second", "moment", "afterwards", "beforehand", "ago", "later", "recently", "soon", "earlier", "example", "case", "fact", "reason", "part", "point", "area", "problem", "question", "answer", "story", "idea", "plan", "number", "group", "kind", "type", "sort", "man", "woman", "child", "person", "friend", "family", "mother", "father", "brother", "sister", "son", "daughter", "husband", "wife", "boy", "girl", "baby", "adult", "teacher", "student", "student_body", "class", "school", "college", "university", "team", "player", "game", "player_count", "animal", "dog", "cat", "bird", "fish", "horse", "cow", "sheep", "pig", "chicken", "food", "water", "bread", "milk", "meat", "fruit", "vegetable", "egg", "rice", "pasta", "house", "home", "room", "bed", "chair", "table", "door", "window", "wall", "floor", "car", "bus", "train", "plane", "bicycle", "boat", "street", "road", "park", "garden", "city", "town", "village", "country", "world", "land", "sea", "ocean", "sun", "moon", "star", "sky", "cloud", "rain", "snow", "storm", "wind", "weather", "temperature", "hot", "cold", "warm", "cool", "happy", "sad", "angry", "fearful", "afraid", "excited", "bored", "tired", "hungry", "thirsty", "love", "like", "dislike", "hate", "watch", "hear", "listen", "speak", "talk", "ask", "understand", "remember", "forget", "believe", "hope", "wish");
        addWords("websites", "google", "youtube", "facebook", "twitter", "instagram", "tiktok", "vine", "reddit", "wikipedia", "netflix", "twitch", "ebay", "discord", "snapchat", "spotify", "curseforge", "modrinth", "zoom", "skype", "teams", "uber", "uber_eats", "lyft", "google_maps", "goodl_drive", "messenger", "telegram", "steam", "itch_i_o");
    }

    public static void addWords(String tag, String... words) {
        final Set<String> dictionary = DICTIONARIES.computeIfAbsent(tag, k -> new HashSet<>());
        for (String word : words) {
            if (dictionary.contains(word)) {
                throw new IllegalStateException("Duplicate entry " + word + " in set " + tag);
            }
            if (!word.toLowerCase(Locale.ROOT).equals(word)) {
                throw new IllegalStateException("Word " + word + " has an uppercase letter!");
            }
            if (word.contains(" ")) {
                throw new IllegalStateException("word " + word + " contains a space.");
            }
            dictionary.add(word);
            ALL_WORDS.add(word);
        }
    }
}