package net.darkhax.ghostgear.common.impl;

import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class GhostGear {

    public static final String MOD_ID = "ghostgear";
    public static final String MOD_NAME = "Ghost Gear";
    public static final Logger LOG = LoggerFactory.getLogger(MOD_NAME);
    private static final Map<String, ResourceLocation> IDS = new HashMap<>();

    public static ResourceLocation id(String path) {
        return IDS.computeIfAbsent(path, k -> ResourceLocation.fromNamespaceAndPath(MOD_ID, k));
    }
}