package net.darkhax.ghostgear.common.impl.spiritbox;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.ghostgear.common.impl.GhostGear;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class SpiritBoxMenu extends class_1703 {

    public static final CachedSupplier<class_3917<SpiritBoxMenu>> TYPE = CachedSupplier.cache(() -> class_7923.field_41187.method_10223(GhostGear.id("spirit_box"))).cast();

    private final class_3914 levelAccess;
    private final class_3913 data;

    public static SpiritBoxMenu clientMenu(int containerId, class_1661 playerInv) {
        return new SpiritBoxMenu(TYPE.get(), containerId, new class_3919(2), class_3914.field_17304);
    }

    public static SpiritBoxMenu serverMenu(int containerId, class_1661 playerInv, SpiritBoxBlockEntity box) {
        return new SpiritBoxMenu(TYPE.get(), containerId, box.getDataAccess(), class_3914.method_17392(Objects.requireNonNull(box.method_10997()), box.method_11016()));
    }

    protected SpiritBoxMenu(@Nullable class_3917<?> menuType, int containerId, class_3913 boxData, class_3914 levelAccess) {
        super(menuType, containerId);
        this.levelAccess = levelAccess;
        this.data = boxData;
        this.method_17360(boxData);
    }

    public void cycleScanMode() {
        this.setScanMode(cycleEnum(this.getScanMode(), ScanMode.class, true));
    }

    public ScanMode getScanMode() {
        return ScanMode.values()[this.data.method_17390(0)];
    }

    public void setScanMode(ScanMode scanMode) {
        this.method_7606(0, scanMode.ordinal());
    }

    public void cycleScanSpeed() {
        this.setScanSpeed(cycleEnum(this.getScanSpeed(), ScanSpeed.class, true));
    }

    public void setScanSpeed(ScanSpeed scanSpeed) {
        this.method_7606(1, scanSpeed.ordinal());
    }

    public ScanSpeed getScanSpeed() {
        return ScanSpeed.values()[data.method_17390(1)];
    }

    public void method_7606(int id, int value) {
        super.method_7606(id, value);
        this.method_37420();
    }

    @NotNull
    @Override
    public class_1799 method_7601(@NotNull class_1657 player, int i) {
        return class_1799.field_8037;
    }

    @Override
    public boolean method_7597(@NotNull class_1657 player) {
        return method_17695(this.levelAccess, player, SpiritBoxBlock.TYPE.get());
    }

    @Override
    public boolean method_7604(class_1657 player, int id) {
        switch (id) {
            case 0 -> this.cycleScanMode();
            case 1 -> this.cycleScanSpeed();
        }
        return true;
    }

    public static <T extends Enum<T>> T cycleEnum(T current, Class<T> enumClass, boolean forward) {
        final T[] values = enumClass.getEnumConstants();
        int index = current.ordinal() + (forward ? 1 : -1);
        if (index < 0) {
            index = values.length - 1;
        }
        if (index >= values.length) {
            index = 0;
        }
        return values[index];
    }
}
