/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.ghostgear.common.impl.spiritbox;

import net.darkhax.ghostgear.common.impl.GhostGear;
import net.darkhax.ghostgear.common.impl.spiritbox.ScanMode;
import net.darkhax.ghostgear.common.impl.spiritbox.ScanSpeed;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SpiritBoxScreen
extends AbstractContainerScreen<SpiritBoxMenu> {
    private static final ResourceLocation TEXTURE = GhostGear.id("textures/gui/spirit_box.png");
    private Button modeButton;
    private Button speedButton;

    public SpiritBoxScreen(SpiritBoxMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        int centerX = (this.width - this.imageWidth) / 2;
        int centerY = (this.height - this.imageHeight) / 2;
        this.modeButton = Button.builder((Component)((SpiritBoxMenu)this.menu).getScanMode().displayName(), this::onModeClicked).tooltip(Tooltip.create((Component)((SpiritBoxMenu)this.menu).getScanMode().description())).pos(centerX + 10, centerY + 40).size(150, 20).build();
        this.speedButton = Button.builder((Component)((SpiritBoxMenu)this.menu).getScanSpeed().displayName(), this::onSpeedClicked).tooltip(Tooltip.create((Component)((SpiritBoxMenu)this.menu).getScanSpeed().description())).pos(centerX + 10, centerY + 70).size(150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.modeButton);
        this.addRenderableWidget((GuiEventListener)this.speedButton);
        ((SpiritBoxMenu)this.menu).addSlotListener(new ContainerListener(){

            public void slotChanged(@NotNull AbstractContainerMenu menu, int slot, @NotNull ItemStack stack) {
            }

            public void dataChanged(@NotNull AbstractContainerMenu menu, int slot, int value) {
                switch (slot) {
                    case 0: {
                        ScanMode mode = ScanMode.values()[value];
                        SpiritBoxScreen.this.modeButton.setMessage(mode.displayName());
                        SpiritBoxScreen.this.modeButton.setTooltip(Tooltip.create((Component)mode.description()));
                        break;
                    }
                    case 1: {
                        ScanSpeed speed = ScanSpeed.values()[value];
                        SpiritBoxScreen.this.speedButton.setMessage(speed.displayName());
                        SpiritBoxScreen.this.speedButton.setTooltip(Tooltip.create((Component)speed.description()));
                    }
                }
            }
        });
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0xFFFFFF, false);
    }

    private void onModeClicked(Button button) {
        ((SpiritBoxMenu)this.menu).cycleScanMode();
        this.clickMenuButton(0);
        button.setMessage(((SpiritBoxMenu)this.menu).getScanMode().displayName());
    }

    private void onSpeedClicked(Button button) {
        ((SpiritBoxMenu)this.menu).cycleScanSpeed();
        this.clickMenuButton(1);
        button.setMessage(((SpiritBoxMenu)this.menu).getScanSpeed().displayName());
    }

    private void clickMenuButton(int buttonId) {
        if (this.minecraft != null && this.minecraft.gameMode != null) {
            this.minecraft.gameMode.handleInventoryButtonClick(((SpiritBoxMenu)this.menu).containerId, buttonId);
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}

