/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.common.impl;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.darkhax.enchdesc.common.impl.Config;
import net.darkhax.enchdesc.common.mixin.patch.AccessorAbstractContainerScreen;
import net.darkhax.pricklemc.common.api.config.ConfigManager;
import net.darkhax.pricklemc.common.api.util.CachedSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnchantmentDescriptionsMod {
    public static final String MOD_ID = "enchdesc";
    public static final String MOD_NAME = "EnchantmentDescriptions";
    public static final Logger LOG = LoggerFactory.getLogger((String)"EnchantmentDescriptions");
    public static final String[] KEY_TYPES = new String[]{"desc", "description", "info"};
    public static final CachedSupplier<Config> config = CachedSupplier.cache(() -> (Config)ConfigManager.load((String)MOD_ID, (Object)new Config()));
    private static final Set<String> missingEnchants = ConcurrentHashMap.newKeySet();

    public static ItemStack getHoveredStack() {
        AccessorAbstractContainerScreen accessor;
        Slot slot;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AccessorAbstractContainerScreen && (slot = (accessor = (AccessorAbstractContainerScreen)screen).enchdesc$hoveredSlot()) != null && slot.hasItem()) {
            return slot.getItem();
        }
        return ItemStack.EMPTY;
    }

    public static boolean canDisplayDescription() {
        Config cfg = (Config)config.get();
        return !(!cfg.enabled || !EnchantmentDescriptionsMod.hasEnchantments(EnchantmentDescriptionsMod.getHoveredStack()) || cfg.only_on_books && EnchantmentDescriptionsMod.getHoveredStack().getItem() != Items.ENCHANTED_BOOK || cfg.only_in_enchanting_table && !(Minecraft.getInstance().screen instanceof EnchantmentScreen));
    }

    public static boolean hasEnchantments(ItemStack stack) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        ItemEnchantments stored = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS);
        return enchantments != null && !enchantments.isEmpty() || stored != null && !stored.isEmpty();
    }

    public static Component getKeybindText() {
        return ((Config)EnchantmentDescriptionsMod.config.get()).activate_text;
    }

    public static boolean isKeybindConditionMet() {
        return !((Config)EnchantmentDescriptionsMod.config.get()).require_keybind || Minecraft.getInstance().hasShiftDown();
    }

    public static void insertDescriptions(Holder<Enchantment> enchantment, int level, Consumer<Component> lines) {
        MutableComponent description;
        if (EnchantmentDescriptionsMod.canDisplayDescription() && EnchantmentDescriptionsMod.isKeybindConditionMet() && (description = EnchantmentDescriptionsMod.getDescription(enchantment, ((ResourceKey)enchantment.unwrapKey().orElseThrow()).identifier(), level)) != null) {
            Config cfg = (Config)config.get();
            ComponentUtils.mergeStyles((MutableComponent)description, (Style)cfg.style);
            lines.accept((Component)cfg.prefix.copy().append((Component)description).append(cfg.suffix));
        }
    }

    @Nullable
    private static MutableComponent getDescription(Holder<Enchantment> enchantment, Identifier id, int level) {
        ComponentContents componentContents;
        MutableComponent description = EnchantmentDescriptionsMod.getDescription("enchantment." + id.getNamespace() + "." + id.getPath() + ".", level);
        if (description == null && (componentContents = ((Enchantment)enchantment.value()).description().getContents()) instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            description = EnchantmentDescriptionsMod.getDescription(translatable.getKey() + ".", level);
        }
        return description;
    }

    @Nullable
    private static MutableComponent getDescription(String baseKey, int level) {
        for (String keyType : KEY_TYPES) {
            String key = baseKey + keyType;
            if (I18n.exists((String)key)) {
                return Component.translatable((String)key);
            }
            if (!I18n.exists((String)(key = key + "." + level))) continue;
            return Component.translatable((String)key);
        }
        if (!missingEnchants.contains(baseKey)) {
            LOG.warn("Enchantment {} does not have a description!", (Object)baseKey);
            missingEnchants.add(baseKey);
        }
        return null;
    }
}

