package net.darkhax.enchdesc.common.impl;

import net.darkhax.enchdesc.common.api.ContextProvider;
import net.darkhax.pricklemc.common.api.config.ConfigManager;
import net.darkhax.pricklemc.common.api.util.CachedSupplier;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_486;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;

public class EnchantmentDescriptionsMod {

    private static final String[] KEY_TYPES = {"desc", "description", "info"};

    public static final CachedSupplier<Config> config = CachedSupplier.cache(() -> ConfigManager.load(Constants.MOD_ID, new Config()));

    public static void setupContext(class_1799 stack) {
        if (canDisplayDescription(stack) && isKeybindConditionMet()) {
            if (stack.method_58657() instanceof ContextProvider provider) {
                provider.enchdesc$setStack(stack);
            }
            if (stack.method_57824(class_9334.field_49643) instanceof ContextProvider provider) {
                provider.enchdesc$setStack(stack);
            }
        }
    }

    public static void revertContext(class_1799 stack) {
        if (stack.method_58657() instanceof ContextProvider provider) {
            provider.enchdesc$setStack(class_1799.field_8037);
        }
        if (stack.method_57824(class_9334.field_49643) instanceof ContextProvider provider) {
            provider.enchdesc$setStack(class_1799.field_8037);
        }
    }

    public static boolean canDisplayDescription(class_1799 stack) {
        final Config cfg = config.get();
        return cfg.enabled &&
               hasEnchantments(stack) &&
               (!cfg.only_on_books || stack.method_7909() == class_1802.field_8598) &&
               (!cfg.only_in_enchanting_table || class_310.method_1551().field_1755 instanceof class_486);
    }

    public static class_2561 getKeybindText() {
        return config.get().activate_text;
    }

    public static boolean isKeybindConditionMet() {
        return !config.get().require_keybind || class_437.method_25442();
    }

    private static boolean hasEnchantments(class_1799 stack) {
        return !stack.method_57825(class_9334.field_49633, class_9304.field_49385).method_57543() || !stack.method_57825(class_9334.field_49643, class_9304.field_49385).method_57543();
    }

    public static void insertDescriptions(class_6880<class_1887> enchantment, int level, Consumer<class_2561> lines) {
        final class_5250 description = getDescription(enchantment, enchantment.method_40230().orElseThrow().method_29177(), level);
        if (description != null) {
            final Config cfg = config.get();
            class_2564.method_10889(description, cfg.style);
            lines.accept(cfg.prefix.method_27661().method_10852(description).method_10852(cfg.suffix));
        }
    }

    @Nullable
    private static class_5250 getDescription(class_6880<class_1887> enchantment, class_2960 id, int level) {
        class_5250 description = getDescription("enchantment." + id.method_12836() + "." + id.method_12832() + ".", level);
        if (description == null && enchantment.comp_349().comp_2686().method_10851() instanceof class_2588 translatable) {
            description = getDescription(translatable.method_11022() + ".", level);
        }
        return description;
    }

    @Nullable
    private static class_5250 getDescription(String baseKey, int level) {
        for (String keyType : KEY_TYPES) {
            String key = baseKey + keyType;
            if (class_1074.method_4663(key)) {
                return class_2561.method_43471(key);
            }
            key = key + "." + level;
            if (class_1074.method_4663(key)) {
                return class_2561.method_43471(key);
            }
        }
        return null;
    }
}