package net.darkhax.enchdesc.common.impl;

import net.darkhax.enchdesc.common.mixin.patch.AccessorAbstractContainerScreen;
import net.darkhax.pricklemc.common.api.config.ConfigManager;
import net.darkhax.pricklemc.common.api.util.CachedSupplier;
import net.minecraft.class_1074;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_486;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class EnchantmentDescriptionsMod {

    public static final String MOD_ID = "enchdesc";
    public static final String MOD_NAME = "EnchantmentDescriptions";
    public static final Logger LOG = LoggerFactory.getLogger(MOD_NAME);
    public static final String[] KEY_TYPES = {"desc", "description", "info"};
    public static final CachedSupplier<Config> config = CachedSupplier.cache(() -> ConfigManager.load(MOD_ID, new Config()));
    private static final Set<String> missingEnchants = ConcurrentHashMap.newKeySet();

    /**
     * Attempts to get the stack in the slot the player is currently hovering over. If the slot does not exist this will
     * be empty.
     *
     * @return The item in the currently hovered slot.
     */
    public static class_1799 getHoveredStack() {
        if (class_310.method_1551().field_1755 instanceof AccessorAbstractContainerScreen accessor) {
            final class_1735 slot = accessor.enchdesc$hoveredSlot();
            if (slot != null && slot.method_7681()) {
                return slot.method_7677();
            }
        }
        return class_1799.field_8037;
    }

    public static boolean canDisplayDescription() {
        final Config cfg = config.get();
        return cfg.enabled && hasEnchantments(getHoveredStack()) && (!cfg.only_on_books || getHoveredStack().method_7909() == class_1802.field_8598) && (!cfg.only_in_enchanting_table || class_310.method_1551().field_1755 instanceof class_486);
    }

    public static boolean hasEnchantments(class_1799 stack) {
        final class_9304 enchantments = stack.method_58694(class_9334.field_49633);
        final class_9304 stored = stack.method_58694(class_9334.field_49643);
        return (enchantments != null && !enchantments.method_57543()) || (stored != null && !stored.method_57543());
    }

    public static class_2561 getKeybindText() {
        return config.get().activate_text;
    }

    public static boolean isKeybindConditionMet() {
        return !config.get().require_keybind || class_310.method_1551().method_74187();
    }

    public static void insertDescriptions(class_6880<class_1887> enchantment, int level, Consumer<class_2561> lines) {
        if (canDisplayDescription() && isKeybindConditionMet()) {
            final class_5250 description = getDescription(enchantment, enchantment.method_40230().orElseThrow().method_29177(), level);
            if (description != null) {
                final Config cfg = config.get();
                class_2564.method_10889(description, cfg.style);
                lines.accept(cfg.prefix.method_27661().method_10852(description).method_10852(cfg.suffix));
            }
        }
    }

    @Nullable
    private static class_5250 getDescription(class_6880<class_1887> enchantment, class_2960 id, int level) {
        class_5250 description = getDescription("enchantment." + id.method_12836() + "." + id.method_12832() + ".", level);
        if (description == null && enchantment.comp_349().comp_2686().method_10851() instanceof class_2588 translatable) {
            description = getDescription(translatable.method_11022() + ".", level);
        }
        return description;
    }

    @Nullable
    private static class_5250 getDescription(String baseKey, int level) {
        for (String keyType : KEY_TYPES) {
            String key = baseKey + keyType;
            if (class_1074.method_4663(key)) {
                return class_2561.method_43471(key);
            }
            key = key + "." + level;
            if (class_1074.method_4663(key)) {
                return class_2561.method_43471(key);
            }
        }
        if (!missingEnchants.contains(baseKey)) {
            LOG.warn("Enchantment {} does not have a description!", baseKey);
            missingEnchants.add(baseKey);
        }
        return null;
    }
}