package net.darkhax.deathknell.common.impl.message;

import net.darkhax.deathknell.common.api.message.IDeathMessage;
import net.minecraft.class_2561;

/**
 * A simple death message provider.
 */
public record DeathMessage(String key) implements IDeathMessage {

    public DeathMessage(String key) {
        this.key = "message.deathknell." + key;
    }

    @Override
    public class_2561 getMessage(Object... args) {
        return class_2561.method_43469(key, IDeathMessage.remapArgs(args));
    }

    @Override
    public class_2561 getSubMessage(String alt, Object... args) {
        return class_2561.method_43469(key + "." + alt, IDeathMessage.remapArgs(args));
    }
}