package net.darkhax.deathknell.common.api.message;

import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

/**
 * This interface defines a factory for generating death messages.
 */
public interface IDeathMessage {

    /**
     * Generates the message to display for this death message.
     *
     * @param args The message parameters such as victim name and killer name.
     * @return The death message to display.
     */
    class_2561 getMessage(Object... args);

    /**
     * Generates a sub-variant of the death message.
     *
     * @param alt  The variant suffix to generate.
     * @param args The message parameters such as victim name and killer name.
     * @return The death message to display.
     */
    class_2561 getSubMessage(String alt, Object... args);

    /**
     * Remaps certain message parameter types into their display friendly counterparts.
     * <p>
     * LivingEntity -> LivingEntity#getDisplayName
     * <p>
     * ItemStack -> ItemStack#getDisplayName
     *
     * @param args The message parameters to remap.
     * @return The remapped message parameters.
     */
    static Object[] remapArgs(Object[] args) {
        final Object[] remapped = new Object[args.length];
        for (int i = 0; i < args.length; i++) {
            Object obj = args[i];
            if (obj instanceof class_1309 living) {
                obj = living.method_5476();
            }
            else if (obj instanceof class_1799 stack) {
                obj = stack.method_7954();
            }
            remapped[i] = obj;
        }
        return remapped;
    }
}