/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.common.features.flatblocks;

import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.block.IBlockHooks;
import net.darkhax.darkutilities.common.features.flatblocks.BlockFlatTile;
import net.darkhax.darkutilities.common.features.flatblocks.BlockFlatTileRotatable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockFlatTileRotatableLightningUpgrade
extends BlockFlatTileRotatable
implements IBlockHooks {
    private final Supplier<Block> upgradeTo;

    public BlockFlatTileRotatableLightningUpgrade(BlockFlatTile.CollisionEffect collisionEffect, Supplier<Block> upgradeTo) {
        this(BlockFlatTile.BLOCK_PROPERTIES, collisionEffect, upgradeTo);
    }

    public BlockFlatTileRotatableLightningUpgrade(BlockBehaviour.Properties properties, BlockFlatTile.CollisionEffect collisionEffect, Supplier<Block> upgradeTo) {
        super(properties, collisionEffect);
        this.upgradeTo = upgradeTo;
    }

    public void onLightningStrike(BlockState state, Level level, BlockPos pos, LightningBolt lightning) {
        this.convertPlates(this.upgradeTo.get(), level, pos, 16);
    }

    public void onLightningStrikeIndirect(BlockState state, Level level, BlockPos pos, LightningBolt lightning, BlockPos strikeOrigin) {
        this.onLightningStrike(state, level, pos, lightning);
    }

    private void convertPlates(Block to, Level world, BlockPos startPos, int attempts) {
        BlockPos.MutableBlockPos mutable = startPos.mutable();
        for (int attempt = 0; attempt < attempts; ++attempt) {
            Direction pointing = this.convertPlates(to, world, (BlockPos)mutable);
            if (pointing == null) {
                return;
            }
            mutable.move(pointing);
        }
    }

    private Direction convertPlates(Block to, Level world, BlockPos platePos) {
        BlockState state = world.getBlockState(platePos);
        if (state.is((Block)this)) {
            Direction plateDirection = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            boolean platePowered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
            world.setBlockAndUpdate(platePos, (BlockState)((BlockState)to.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)plateDirection)).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(platePowered)));
            world.levelEvent(3002, platePos, -1);
            return plateDirection;
        }
        return null;
    }
}

